<?php

namespace App\Helpers;

Use Config;
Use Redirect;
Use Session;
Use Input;
Use HTML;
Use URL;
Use DB;
Use Firebase;
Use Push;
Use Htmlhelpers;
Use Mail;
Use Swift_SmtpTransport;
Use Swift_Mailer;
Use Request;
Use Auth;

class Helpers {

    public static function setActive($path) {
        return Request::is($path . '*') ? ' class=active' : '';
    }
	
	public static function getValueByKey($config_key) {
        $config = DB::table('configurations')->where('config_key', $config_key)->first();
		return $config->config_value ? $config->config_value : '';
    }

    public static function setActiveParentItem($path) {
        return Request::is($path . '*') ? ' active' : '';
    }

    public static function setActiveInnerItem($path) {
        return Request::is($path) ? ' active' : '';
    }

    public static function setActiveGroup($pathArray = array()) {
        foreach ($pathArray as $path) {
            if (Request::is($path . '*')) {
                return "active";
            }
        }
        return "";
    }

    public static function checkUserType() {
        $usersArray = Auth::user();
        if (isset($usersArray)) {
            if ($usersArray->is_admin === 1) {
                return TRUE;
            } else {
                return FALSE;
            }
        } else {
            return FALSE;
        }
    }

    public static function sendSms($txtmsg,$mobile){
		$mobile=str_replace('$$',',',$mobile);
		$txtmsg=rawurlencode($txtmsg);
		$curl = curl_init();
		curl_setopt_array($curl, array(
		  CURLOPT_URL => "https://www.fast2sms.com/dev/bulkV2?authorization=fUc5OLj8evsVPT764mtgHkJRqdBZNxryIn0aiKFwD3AX9EG2hYrKvWTtzQDbYhl6mnUSiIHFJPsR1ZNM&sender_id=TXTIND&message=".urlencode($txtmsg)."&route=v3&numbers=".urlencode($mobile),
		  CURLOPT_RETURNTRANSFER => true,
		  CURLOPT_ENCODING => "",
		  CURLOPT_MAXREDIRS => 10,
		  CURLOPT_TIMEOUT => 30,
		  CURLOPT_SSL_VERIFYHOST => 0,
		  CURLOPT_SSL_VERIFYPEER => 0,
		  CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
		  CURLOPT_CUSTOMREQUEST => "GET",
		  CURLOPT_HTTPHEADER => array(
			"cache-control: no-cache"
		  ),
		));

		$response = curl_exec($curl);
		$err = curl_error($curl);
		curl_close($curl);
		if($err){
		  #echo "cURL Error #:" . $err;
		}else{
		  #echo $response;
		  return true;
		}
	}
	
	public static function SendMail($templates, $datamessage){
	    header('Access-Control-Allow-Origin: *');
		/*
		$fromemail = isset($datamessage['fromemail'])?$datamessage['fromemail']:'support@mybat11.com';
		$transport = new Swift_SmtpTransport('smtp.mailgun.org', 587);
		$transport->setUsername('postmaster@mybat11.com');
		$transport->setPassword('fa2463d4842508106e5c9dda46c2c9a5-a9919d1f-382587ad');
		*/
		
		$fromemail = isset($datamessage['fromemail'])?$datamessage['fromemail']:'support@mybat11.com';
		$transport = new Swift_SmtpTransport('mail.24livehost.com', 587);
		$transport->setUsername('ds25@24livehost.com');
		$transport->setPassword('Dsmtp@909#');
		
		$swift_mailer = new Swift_Mailer($transport);
		Mail::setSwiftMailer($swift_mailer);
		Mail::send($templates, $datamessage, function ($m) use ($datamessage){
			$m->from('support@ludocrush.com', 'LUDOCRUSH');
			$m->to($datamessage['email'])->subject($datamessage['subject']);
		});
	}

    public static function getPreviousFifteenYears($n = 0) {
        $years_array[0] = __('messages.Year');
        $year = date('Y');
        $total = 15;
        if (!empty($n)) {
            $total = $n;
        }
        for ($i = 0; $i <= $total; $i++) {
            $year = $year - $i;
            $years_array[$year] = $year;
            $year = date('Y');
        }
        return $years_array;
    }

    public static function webPreview($websiteURL = '') {
        $preview_img = '';
        if ($websiteURL) {
            $websiteURL = 'https://www.' . $websiteURL;
            $api_response = file_get_contents("https://www.googleapis.com/pagespeedonline/v2/runPagespeed?url=$websiteURL&screenshot=true");
            //decode json data
            $result = json_decode($api_response, true);
            //screenshot data
            $screenshot = $result['screenshot']['data'];
            $screenshot = str_replace(array('_', '-'), array('/', '+'), $screenshot);
            //display screenshot image
            $preview_img = "<img class=\"img-responsive\" src=\"data:image/jpeg;base64," . $screenshot . "\" />";
        }

        return $preview_img;
    }

    public static function projectName() {
        return "ValdemarAuto";
    }

    public static function popular() {
        return "ValdemarAuto";
    }

    public static function checkEmail($email) {
        if (strpos($email, '@') !== false) {
            $split = explode('@', $email);
            return (strpos($split['1'], '.') !== false ? true : false);
        } else {
            return false;
        }
    }

    public static function controllerName() {
        $routeArray = app('request')->route()->getAction();
        $controllerAction = class_basename($routeArray['controller']);
        list($controller, $action) = explode('@', $controllerAction);
        return $controller;
    }

    public static function actionName() {
        $routeArray = app('request')->route()->getAction();
        $controllerAction = class_basename($routeArray['controller']);
        list($controller, $action) = explode('@', $controllerAction);
        return $action;
    }

    /**
     * use to access the control from front side
     *
     */
    public static function accessrules() {
        header('Access-Control-Allow-Origin: *');
        header("Access-Control-Allow-Credentials: true");
        header('Access-Control-Allow-Methods: GET, PUT, POST, DELETE, OPTIONS');
        header('Access-Control-Max-Age: 1000');
        header('Access-Control-Allow-Headers: Origin, Content-Type, X-Auth-Token, Authorization');
        date_default_timezone_set('Asia/Kolkata');
    }

    /**
     * to set the headers for all the status
     *
     */
    public static function _getStatusCodeMessage($status) {
        $code = [
            200 => 'OK',
            400 => 'Bad Request',
            401 => 'Unauthorized Request',
            403 => 'Forbidden',
            404 => 'Not Found',
            500 => 'Internal Server Error',
            501 => 'Not Implemented'
        ];
        return (isset($code[$status])) ? $code[$status] : "";
    }

    public static function setHeader($status) {
        $status_header = 'HTTP/1.1 ' . $status . ' ' . Helpers::_getStatusCodeMessage($status);
        $content_type = "application/json; charset=utf-8";
        header($status_header);
        header('Content-type: ' . $content_type);
        header('X-Powered-By: ' . "amodisc <http://.in/>");
    }

    public static function imageExtension($file) {
        $filename = $file->getClientOriginalName();
        $extension = $file->getClientOriginalExtension();
        $ext = array('jpg', 'JPG', 'jpeg', 'gif', 'png');
        if (!in_array($extension, $ext)) {
            return false;
        }
        return true;
    }

    public static function imageUpload($file, $destinationPath, $fileName) {

        $array = array();

        foreach ($file as $fileimage) {
            $filename = $fileimage->getClientOriginalName();
            // pr($fileName.time());die;
            $changeImagename = md5($fileName . time());
            $extension = $fileimage->getClientOriginalExtension();
            // pr($fileName);die;
            $ext = array('jpg', 'JPG', 'jpeg', 'gif', 'png');
            $newfilename = $changeImagename . '.' . $extension;

            if (file_exists($destinationPath . '/' . $newfilename)) {
                $info = pathinfo($newfilename);
                $imageNamee = $info['filename'] . '-' . rand(100, 999);
                $newfilename = $imageNamee . "." . $info['extension'];
            }

            $array[] = $newfilename;
            $upload_success = $fileimage->move($destinationPath, $newfilename);
            $resi = $destinationPath . '/' . $newfilename;
            $resizeimage = Helpers::resize_image($resi);
            $resizeimage = Helpers::compress_image($resi, 80);
        }

        $imageNames = implode('{$(~)$}', $array);

        return $imageNames;
    }

    public static function imageSingleUpload($file, $destinationPath, $fileName) {
        $filename = $file->getClientOriginalName();
        $extension = $file->getClientOriginalExtension();
        $ext = array("jpg", "jpeg", "png", "gif", "zip", "bmp", "JPG", "pdf");
        if (!in_array($extension, $ext)) {
            echo "Invalid extension of file you uploaded. You can only upload image or pdf.";
        }
        $newfilename = $filename;
        if (file_exists($destinationPath . '/' . $newfilename)) {
            $info = pathinfo($newfilename);
            $imageNamee = $info['filename'] . '.' . $fileName;
            $newfilename = $imageNamee . '.' . $extension;
        }
        $resi = $destinationPath . '/' . $newfilename;
        $upload_success = $file->move($destinationPath, $newfilename);
        $wid = 150;
        $resizeimage = Helpers::resize_image($resi, $wid);
        $resizeimage = Helpers::compress_image($resi, 100);
        return $newfilename;
    }

    public static function compress_image($destination_url, $quality) {
        $sizeee = filesize($destination_url);
        if ($sizeee > 1000) {
            $info = getimagesize($destination_url);
            if ($info['mime'] == 'image/jpeg')
                $image = imagecreatefromjpeg($destination_url);
            elseif ($info['mime'] == 'image/gif')
                $image = imagecreatefromgif($destination_url);
            elseif ($info['mime'] == 'image/png')
                $image = imagecreatefrompng($destination_url);
            imagejpeg($image, $destination_url, $quality);
        }
        return $destination_url;
    }

    public static function resize_image($destination_url, $wid) {
        $info = getimagesize($destination_url);
        if ($info['mime'] == 'image/jpeg' || $info['mime'] == 'image/jpg') {
            $src = imagecreatefromjpeg($destination_url);
        } else if ($info['mime'] == 'image/png') {
            $src = imagecreatefrompng($destination_url);
        } else {
            $src = imagecreatefromgif($destination_url);
        }
        list($width, $height) = getimagesize($destination_url);
        if ($width > $wid) {
            $newwidth = $wid;
            $newheight = ($height / $width) * $newwidth;
            $tmp = imagecreatetruecolor($newwidth, $newheight);
            imagecopyresampled($tmp, $src, 0, 0, 0, 0, $newwidth, $newheight, $width, $height);
            imagejpeg($tmp, $destination_url, 100);
            imagedestroy($src);
            imagedestroy($tmp);
        }
        return $destination_url;
    }

    // Function to get the client IP address
    public static function getClientIpAddress() {
        $ipaddress = '';
        if (getenv('HTTP_CLIENT_IP'))
            $ipaddress = getenv('HTTP_CLIENT_IP');
        else if (getenv('HTTP_X_FORWARDED_FOR'))
            $ipaddress = getenv('HTTP_X_FORWARDED_FOR');
        else if (getenv('HTTP_X_FORWARDED'))
            $ipaddress = getenv('HTTP_X_FORWARDED');
        else if (getenv('HTTP_FORWARDED_FOR'))
            $ipaddress = getenv('HTTP_FORWARDED_FOR');
        else if (getenv('HTTP_FORWARDED'))
            $ipaddress = getenv('HTTP_FORWARDED');
        else if (getenv('REMOTE_ADDR'))
            $ipaddress = getenv('REMOTE_ADDR');
        else
            $ipaddress = 'UNKNOWN';
        return $ipaddress;
    }
    
    /** 
     * @method sendMail
     * @description to used to send the email
     * 
     * @hint ($dataMessage['to']: to email address, $dataMessage['subject']: email subject, $dataMessage['view'] : name of the email view,)
     * @hint ($dataMessage['params']['key'] : to pass the parameters/variable data to view with specified 'key')
     * 
     * @param type array $dataMessage 
     * 
     * @return type boolean/string exception
     * 
     */
    public static function sendMailOld($dataMessage) {
        $fromEmail = (!empty($dataMessage['fromEmail'])) ? $dataMessage['fromEmail'] : env('MAIL_FROM_ADDRESS');
        $fromName = (!empty($dataMessage['fromName'])) ? $dataMessage['fromName'] : self::projectName();
        $emailView = (!empty($dataMessage['view'])) ? $dataMessage['view'] : 'common'; //set the default view to common(with title and content keys)
        try {
            Mail::send('emails.'.$emailView, $dataMessage, function ($m) use ($dataMessage, $fromEmail, $fromName) {
                $m->from($fromEmail, $fromName);
                $m->to($dataMessage['to'])->subject($dataMessage['subject']);
            });
        } catch (\Exception $e) {
            return $e->getMessage();
        }
    }
}

?>