<?php
namespace App\Http\Controllers\Api;
use App\Http\Controllers\Api\ApiController as ApiController;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;

use App\Models\User; 
use App\Models\Tournament; 
use App\Models\Cointransaction;
use App\Models\Usergameinfo;
use App\Models\Order;
use App\Models\Kyc;

use Illuminate\Support\Facades\Auth; 
use Validator;
use DB;
use App\Coupon;
use Carbon\Carbon;
use Helpers;
class AuthController extends ApiController
{
	public function register(Request $request) {    
		$validator = Validator::make($request->all(),[ 
			'name' => 'required',
			'email' => 'required|email',
			'password' => 'required',  
			'c_password' => 'required|same:password', 
		]);   
		if($validator->fails()) { 
			return $this->sendError('Validation Error.', $validator->errors(), 401);
		}
		$input = $request->all(); 
		$user = User::where('email', $input['email'])->first();
		if (!$user) { 
			$input['password'] = bcrypt($input['password']);
			$user = User::create($input); 
			#$success['token'] =  $user->createToken('AppName')->accessToken;
			$success['name'] =  $user->name;
			return $this->sendResponse($success, 'User register successfully.');
		}else{
			return $this->sendError('Validation Error.', ['error'=> array('email' => ['0' => 'Email already exist!!'])], 401);
		} 
	}

	public function login(){ 
		if(Auth::attempt(['email' => request('email'), 'password' => request('password')])){ 
			$user = Auth::user(); 
			#$success['token'] =  $user->createToken('AppName')-> accessToken;
			$success['userDetails'] =  $user;
			return $this->sendResponse($success, 'User logged in successfully.'); 
		}else{
			return $this->sendError('Unauthorised Error.', ['error'=>'Unauthorised'], 401); 
		} 
	}
  
	public function getUser() {
		$user = Auth::user();
		$success['userDetails'] = $user;
		return $this->sendResponse($success, 'User retrieved successfully.');
	}
	
	/* public function getUserById(Request $request) {
		$input = $request->all(); 
		
		$user = User::where('id', $input['user_id'])->first();
		
		$usergameinfo = Usergameinfo::select('users.*', 'usergameinfos.*')
                ->leftJoin('users', 'usergameinfos.userId', '=', 'users.id')
				->Where('users.id', $input['user_id'])
				->first();
				//print_r($usergameinfo); die;
				
		if(!$user){
			return $this->sendError('Not Exist.', ['error'=>'Records not found'], 401); 
		}
		$success['token'] =  $user->createToken('AppName')->accessToken;
		#$success['userDetails'] = $user;
		return $this->sendResponse($success, 'User retrieved successfully.');
	} */
	public function getUserById(Request $request) {
		$input = $request->all(); 
		if(Kyc::where(['user_id' => $input['user_id']])->first()){
			$user = User::select('users.*', 'kycs.panNumber', 'kycs.nameOnCard', 'kycs.accountNumber', 'kycs.ifscCode', 'kycs.panImage', 'kycs.passbookImage')->leftJoin('kycs', 'kycs.user_id', '=', 'users.id')->where('users.id', $input['user_id'])->first();
		}else{
			$user = User::where('id', $input['user_id'])->first();
		}
		$usergameinfo = Usergameinfo::where('userId', $input['user_id'])->first();
		if(!$user){
			return $this->sendError('Not Exist.', ['error'=>'Records not found'], 401); 
		}
		#$success['token'] =  $user->createToken('AppName')->accessToken;
		#$success['userDetails'] = $user;
		if($usergameinfo){
			$usergameinfo = Usergameinfo::select('users.*', 'usergameinfos.*', 'kycs.panIsVerified', 'kycs.accountIsVerified')
                ->leftJoin('users', 'usergameinfos.userId', '=', 'users.id')
                ->leftJoin('kycs', 'kycs.user_id', '=', 'users.id')
				->Where('users.id', $input['user_id'])
				->first();
				//unset($usergameinfo['id']);
				$usergameinfo['id'] = $usergameinfo['userId'];
				$usergameinfo['filepath'] = 'https://'.request()->getHttpHost().'/uploads/avatars/';
			return $this->sendResponse($usergameinfo, 'User retrieved successfully.');	
		}
		else{
			$user['filepath'] = 'https://'.request()->getHttpHost().'/uploads/avatars/';
			#$obj_merged = (object) array_merge((array) $user, (array) $obj2);
			return $this->sendResponse($user, 'User retrieved successfully.');
		}
	}
	
	public function sendotpNew(Request $request){    
		$validator = Validator::make($request->all(),[ 
			'mobileNo' => 'required' 
		]); 
		$addReferalCoin = false;
		if ($validator->fails()) { 
			return $this->sendError('Validation Error.', $validator->errors(), 401);
		}
		$input = $request->all();
		$mobileNo = $input['mobileNo'];
		if(isset($input['referedByCode'])){
			$referalUser = User::where('referalCode', $input['referedByCode'])->first();
			if($referalUser){
				$addReferalCoin = true;
			}else{
				return $this->sendError('Referel Code Error.', ['error' => 'Not a valid code!'], 401);
				exit;
			}
		}
		#if($referalUser)
		$countryCode = isset($input['countryCode'])?$input['countryCode']:'+91';
		$finalMobile = $mobileNo;
		$mobileOtp = mt_rand(100000,999999);
		#$message = 'Your OTP: '.$mobileOtp;
		$message = 'Welcome to Ludo Game, OTP '.$mobileOtp;
		if(Helpers::sendSms($message, $finalMobile)){
			$user = User::where('mobileNo', $input['mobileNo'])->first();
			if (empty($user->mobileNo)){
				$save['mobileNo'] = $input['mobileNo'];
				$save['countryCode'] = isset($input['countryCode'])?$input['countryCode']:'';
				$save['mobileOtp'] = $mobileOtp;
				$save['referedByCode'] = isset($input['referedByCode'])?$input['referedByCode']:'';
				$user = User::create($save); 
				#$user->createToken('AppName')->accessToken;
				$success['mobileNo'] =  $input['mobileNo'];
				#$success['name'] =  $user->name;
				return $this->sendResponse($success, 'OTP sent successfully.');
			}else{
				$update['mobileOtp'] = $mobileOtp;
				if(!isset($input['isResend'])){
					$update['isAlreadyRegistered'] = 1;
				}
				
				$user->update($update);
				$success['mobileNo'] =  $input['mobileNo'];
				#$user->createToken('AppName')->accessToken;
				return $this->sendResponse($success, 'OTP sent successfully.');
			}
		}else{
			return $this->sendError('Server Error.', ['error'=> "Server error, please contact administrator."], 401);
		}
	}
	
	public function sendotp(Request $request) {    
		$validator = Validator::make($request->all(),[ 
			'mobileNo' => 'required' 
		]); 
		$addReferalCoin = false;
		if ($validator->fails()) { 
			return $this->sendError('Validation Error.', $validator->errors(), 401);
		}
		$input = $request->all();
		$mobileNo = $input['mobileNo'];
		if(isset($input['referedByCode'])){
			$referalUser = User::where('referalCode', $input['referedByCode'])->first();
			if($referalUser){
				$addReferalCoin = true;
			}else{
				return $this->sendError('Referel Code Error.', ['error' => 'Not a valid code!'], 401);
				exit;
			}
		}
		#if($referalUser)
		$countryCode = isset($input['countryCode'])?$input['countryCode']:'+91';
		$finalMobile = $countryCode.$mobileNo;
		$mobileOtp = mt_rand(100000,999999);
		#$message = 'Your OTP: '.$mobileOtp;
		$message = 'Welcome to Ludo Game, your sign up OTP requested is '.$mobileOtp.'. Please login and enjoy the game.';
		$url = "https://control.msg91.com/api/sendotp.php?authkey=308452AiUtbMiDKv5df5e052&mobile=".$finalMobile."&message=".$message."&sender=OTPSMS&otp_length=4&otp=".$mobileOtp."&template=5dfd9d57d6fc055cd233d3d5";
		$curl = curl_init();
		curl_setopt_array($curl, array(
			CURLOPT_URL => $url,
			CURLOPT_RETURNTRANSFER => true,
			CURLOPT_ENCODING => "",
			CURLOPT_MAXREDIRS => 10,
			CURLOPT_TIMEOUT => 30,
			CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
			CURLOPT_CUSTOMREQUEST => "POST",
			CURLOPT_POSTFIELDS => "",
			CURLOPT_SSL_VERIFYHOST => 0,
			CURLOPT_SSL_VERIFYPEER => 0,
		));
		$response = curl_exec($curl);
		$err = curl_error($curl);
		curl_close($curl);
		if($err){
			return $this->sendError('Server Error.', ['error'=> "Server error, please contact administrator."], 401);
			#echo "cURL Error #:" . $err;
		}else{
			$user = User::where('mobileNo', $input['mobileNo'])->first();
			if (!$user) {
				$save['mobileNo'] = $input['mobileNo'];
				$save['countryCode'] = isset($input['countryCode'])?$input['countryCode']:'+91';;
				$save['mobileOtp'] = $mobileOtp;
				$save['referedByCode'] = isset($input['referedByCode'])?$input['referedByCode']:'';
				$user = User::create($save); 
				#$user->createToken('AppName')->accessToken;
				$success['mobileNo'] =  $input['mobileNo'];
				#$success['name'] =  $user->name;
				return $this->sendResponse($success, 'OTP sent successfully.');
			}else{
				$update['mobileOtp'] = $mobileOtp;
				if(!isset($input['isResend'])){
					$update['isAlreadyRegistered'] = 1;
				}
				
				$user->update($update);
				$success['mobileNo'] =  $input['mobileNo'];
				#$user->createToken('AppName')->accessToken;
				return $this->sendResponse($success, 'OTP sent successfully.');
			}
		} 
	}
	
	public function randomStrings($length_of_string){ 
		$str_result = 'ABCDEFGHIJKLMNOPQRSTUVWXYZ1234567890abcdefghijklmnopqrstuvwxyz'; 
		return substr(str_shuffle($str_result), 0, $length_of_string); 
	} 
	
	public function verifyotp(Request $request) {    
		$validator = Validator::make($request->all(),[ 
			'mobileOtp' => 'required',
			'mobileNo' => 'required'
		]); 
		$addReferalCoin = false;
		if ($validator->fails()) { 
			return $this->sendError('Validation Error.', $validator->errors(), 401);
		}
		$input = $request->all(); 
		$user = User::where(['mobileNo' => $input['mobileNo'], 'mobileOtp' => $input['mobileOtp']])->first();
		if($user){		
			$usersStatement = DB::select("SHOW TABLE STATUS LIKE 'users'");
			$user_last_inserted_id = $usersStatement[0]->Auto_increment;
			$user_last_inserted_id = $user_last_inserted_id-1;
			$referalCode = $this->randomStrings(5);
			$referalCode = $referalCode.$user_last_inserted_id;
			if(!$user->isAlreadyRegistered){
				$referalUser = User::where('referalCode', $user->referedByCode)->first();
				if($referalUser){
					$addReferalCoin = true;
					$referalupdate['bonusMoney'] = 75;
					$referalUser->update($referalupdate);
					$update['referedBy'] = $referalUser->mobileNo;
				}
				$update['referalCode'] = $referalCode;
			}
			$update['isOtpveryfied'] = 1;
			$update['mobileOtp'] = '';
			$update['mobileVerified'] = 1;
			if($addReferalCoin){
				$update['bonusMoney'] = 75;
			}
			$user->update($update);
			#$user->createToken('AppName')->accessToken;
			$this->dailyBonus($user->id);
			return $this->sendResponse($user, 'OTP verified successfully.');
		}else{
			return $this->sendError('Validation Error.', ['error' => 'Not a valid OTP!'], 401);
		} 
	}
	
	public function setProfile(Request $request) {    
		$validator = Validator::make($request->all(),[ 
			'firstName' => 'required',
			'lastName' => 'required',
			'email' => 'required',
			'gender' => 'required',
			'deviceId' => 'required',
			'mobileNo' => 'required'
		]);  
		$addReferalCoin = false;
		if ($validator->fails()) { 
			return $this->sendError('Validation Error.', $validator->errors(), 401);
		}
		$input = $request->all(); 
		if(isset($input['referedByCode'])){
			$referalUser = User::where('referalCode', $input['referedByCode'])->first();
			if($referalUser){
				$addReferalCoin = true;
			}else{
				return $this->sendError('Invalid', 'Please provide valid referal code', 200);
				exit;
			}
		}
		$user = User::where(['mobileNo' => $input['mobileNo']])->first();
		if($user){
			$update['isProfileUpdated'] = 1;
			$update['firstName'] 	= $input['firstName'];
			$update['lastName'] 	= $input['lastName'];
			$update['email'] 		= $input['email'];
			$update['gender'] 		= $input['gender'];
			$update['deviceId'] 	= $input['deviceId'];
			$update['avatar'] 		= isset($input['avatar'])?$input['avatar']:'';
			if($addReferalCoin){
				$update['bonusMoney'] = 75;
				$update['referedByCode'] = isset($input['referedByCode'])?$input['referedByCode']:'';
			}
			$user->update($update);
			#$user->createToken('AppName')->accessToken;
			return $this->sendResponse($user, 'Profile updated successfully.');
		}else{
			return $this->sendError('Validation Error.', ['error' => 'Not a valid mobile number!'], 401);
		} 
	}
	public function autoLogin(Request $request) { 
		$validator = Validator::make($request->all(),[ 
			'mobileNo' => 'required', 
			'deviceId' => 'required'
		]); 
		
		if ($validator->fails()) { 
			return $this->sendError('Validation Error.', $validator->errors(), 401);
		}
		$input = $request->all();
		$user = User::where(['mobileNo' => $input['mobileNo'],'deviceId'=>$input['deviceId']])->first();
		if($user){
			if($user['isAlreadyRegistered'] == 1 && $user['isOtpveryfied'] == 1 ){
				#$user->createToken('AppName')->accessToken;
				$this->dailyBonus($user->id);
				return $this->sendResponse($user, 'Logged in successfully.');	
			}
		}
		else{
			return $this->sendResponse($user, 'No record found.');	
		}
	}
	
	/**
		This generic function used for get user bonus details.
		This function require one param as below:
		user_id = User id of the current login user;
		This function will return a json object with user Bonus datails.
	**/
	public function dailyBonus($user_id){
		$currentDate    = date('Y-m-d');
		$user_id        = $user_id;
		$condition_array = array(
			'user_id'=>$user_id	
		);
		#$user_data = $this->api->getRecords('ps_user_info', $condition_array);
		$users = User::where(['id' => $user_id])->first();
		$usersArray = $users->toArray();
		if(empty($usersArray)){
			return 0;
		}

		if(!empty($usersArray)){
			if($usersArray['lastBonusDate'] == $currentDate){
				return 0;
			}
		}
		 
		$lastBonusDate = $usersArray['lastBonusDate'];			
		
		//Difference between two dates
		$bonusDayCounter = $usersArray['bonusDayCounter'];
		$bonus_point = 0;
		if($bonusDayCounter == 0 || $bonusDayCounter == 7){
			$bonusDayCounter = 1;
		}else{
			$date1 = date_create($lastBonusDate);
			$date2 = date_create($currentDate);
			$dateDiff = date_diff($date1,$date2);
			$diffInDays = $dateDiff->format("%a");
			if($diffInDays == 1){
				$bonusDayCounter++;
			}else{
				$bonusDayCounter = 1;
			}
		}
		$update['bonusDayCounter'] = $bonusDayCounter;	
		$update['bonusClaimed'] = '0';	
		$update['lastBonusDate'] = $currentDate;
		$users->update($update);
	}
	
	public function updateCoins(Request $request) {    
		$validator = Validator::make($request->all(),[ 
			'userId' => 'required',
			'gameId' => 'required',
			'coins' => 'required',
			'coinType' => 'required',
			'txnDesc' => 'required'
		]);   
		if ($validator->fails()) { 
			return $this->sendError('Validation Error.', $validator->errors(), 401);
		}
		$input = $request->all(); 
		$user = User::where(['id' => $input['userId']])->first();
		$saveTransaction = array();
		if($user){
			$saveTransaction['user_id'] = $input['userId'];
			$saveTransaction['game_id'] = $input['gameId'];
			$saveTransaction['coins'] = $input['coins'];
			$saveTransaction['coin_type'] = $input['coinType'];
			$saveTransaction['txn_type'] = isset($input['txnType'])?$input['txnType']:'1';
			$saveTransaction['txn_desc'] = $input['txnDesc'];
			if(!empty($saveTransaction)){
				$cointransaction = Cointransaction::create($saveTransaction);
			}
			if($input['coinType'] == 1){
				$winningMoney = $user->winningMoney;
				$totalwinningMoney = $winningMoney + $input['coins'];
				$update['winningMoney'] = $totalwinningMoney;
			}else{
				$bonusMoney = $user->bonusMoney;
				$totalbonusMoney = $bonusMoney + $input['coins'];
				$update['bonusMoney'] = $totalbonusMoney;
			}
			$user->update($update);
			#$user->createToken('AppName')->accessToken;
			return $this->sendResponse($user, 'Coins updated successfully.');
		}else{
			return $this->sendError('Validation Error.', ['error' => 'Not a valid player!'], 401);
		} 
	}
	
	public function deductMoney(Request $request) {    
		$validator = Validator::make($request->all(),[ 
			'userId' => 'required',
			'gameId' => 'required',
			'realMoney' => 'required',
			'winningMoney' => 'required',
			'bonusMoney'=>'required',
		]);   
		if ($validator->fails()) { 
			return $this->sendError('Validation Error.', $validator->errors(), 401);
		}
		$input = $request->all(); 
		$user = User::where(['id' => $input['userId']])->first();
		$saveTransaction = array();
		if($user){
			if(isset($input['realMoney']) && $input['realMoney'] > 0){
				$saveTransaction['user_id'] = $input['userId'];
				$saveTransaction['game_id'] = $input['gameId'];
				$saveTransaction['coins'] = $input['realMoney'];
				$saveTransaction['coin_type'] = 3;
				$saveTransaction['txn_type'] = isset($input['txnType'])?$input['txnType']:'2';
				$saveTransaction['txn_desc'] = 'RealMoneyDeduction';
				if(!empty($saveTransaction)){
					$cointransaction = Cointransaction::create($saveTransaction);
				}
				$realMoney = $user->realMoney;
				if($realMoney >= $input['realMoney']){
					$remainingRealMoney = $realMoney - $input['realMoney'];
					$update['realMoney'] = $remainingRealMoney;
				}else{
					return $this->sendError('Validation Error.', ['error' => 'insufficient real money fund!'], 401);
				}
			}
			
			if(isset($input['winningMoney']) && $input['winningMoney'] > 0){
				$saveTransaction['user_id'] = $input['userId'];
				$saveTransaction['game_id'] = $input['gameId'];
				$saveTransaction['coins'] = $input['winningMoney'];
				$saveTransaction['coin_type'] = 3;
				$saveTransaction['txn_type'] = isset($input['txnType'])?$input['txnType']:'2';
				$saveTransaction['txn_desc'] = 'winningMoneyDeduction';
				if(!empty($saveTransaction)){
					$cointransaction = Cointransaction::create($saveTransaction);
				}
				$winningMoney = $user->winningMoney;
				if($winningMoney >= $input['winningMoney']){
					$remainingwinningMoney = $winningMoney - $input['winningMoney'];
					$update['winningMoney'] = $remainingwinningMoney;
				}else{
					return $this->sendError('Validation Error.', ['error' => 'insufficient earn money fund!'], 401);
				}
			}			
			if(isset($input['bonusMoney']) && $input['bonusMoney'] > 0){
				$saveTransaction['user_id'] = $input['userId'];
				$saveTransaction['game_id'] = $input['gameId'];
				$saveTransaction['coins'] = $input['bonusMoney'];
				$saveTransaction['coin_type'] = 3;
				$saveTransaction['txn_type'] = isset($input['txnType'])?$input['txnType']:'2';
				$saveTransaction['txn_desc'] = 'BonusMoneyDeduction';
				if(!empty($saveTransaction)){
					$cointransaction = Cointransaction::create($saveTransaction);
				}
				$bonusMoney = $user->bonusMoney;
				if($bonusMoney >= $input['bonusMoney']){
					$remainingbonusMoney = $bonusMoney - $input['bonusMoney'];
					$update['bonusMoney'] = $remainingbonusMoney;
				}else{
					return $this->sendError('Validation Error.', ['error' => 'insufficient Bonus money fund!'], 401);
				}
			}
			$user->update($update);
			#$user->createToken('AppName')->accessToken;
			return $this->sendResponse($user, 'Money updated successfully.');
		}else{
			return $this->sendError('Validation Error.', ['error' => 'Not a valid player!'], 401);
		} 
	}
	
	
	public function updateTotal(Request $request) {    
		$validator = Validator::make($request->all(),[ 
			'userId' => 'required',
			'gameId' => 'required',
			'gameFrom' => 'required'
		]);   
		if ($validator->fails()) { 
			return $this->sendError('Validation Error.', $validator->errors(), 401);
		}
		$input = $request->all(); 
		$usergameinfo = Usergameinfo::where(['gameId' => $input['gameId'], 'userId' => $input['userId']])->first();
		$saveTransaction = array();
		if($usergameinfo){
			$totalGames = $usergameinfo->totalGames;
			$updateArray['totalGames'] = $totalGames+1;
			if($input['gameFrom'] == 'computer'){
				$totalGamesFromComputer = $usergameinfo->totalGamesFromComputer;
				$updateArray['totalGamesFromComputer'] = $totalGamesFromComputer+1;
			}elseif($input['gameFrom'] == 'friend'){
				$totalGamesFromFriend = $usergameinfo->totalGamesFromFriend;
				$updateArray['totalGamesFromFriend'] = $totalGamesFromFriend+1;
			}elseif($input['gameFrom'] == 'indian'){
				$totalGamesFromIndian = $usergameinfo->totalGamesFromIndian;
				$updateArray['totalGamesFromIndian'] = $totalGamesFromIndian+1;
			}elseif($input['gameFrom'] == 'classic'){
				$totalGamesFromClassic = $usergameinfo->totalGamesFromClassic;
				$updateArray['totalGamesFromClassic'] = $totalGamesFromClassic+1;
			}else{
				$updateArray = array();
			}
			if(!empty($updateArray)){
				$usergameinfo->update($updateArray);
				return $this->sendResponse($usergameinfo, 'Game Total updated successfully.');
			}else{
				return $this->sendError('Validation Error.', ['error' => 'Not a valid game from value!'], 401);
			}
			
		}else{
			$saveArray['userId'] = $input['userId'];
			$saveArray['gameId'] = $input['gameId'];
			$saveArray['totalGames'] = 1;
			if($input['gameFrom'] == 'computer'){
				$saveArray['totalGamesFromComputer'] = 1;
			}elseif($input['gameFrom'] == 'friend'){
				$saveArray['totalGamesFromFriend'] = 1;
			}elseif($input['gameFrom'] == 'indian'){
				$saveArray['totalGamesFromIndian'] = 1;
			}elseif($input['gameFrom'] == 'classic'){
				$saveArray['totalGamesFromClassic'] = 1;
			}
			$usergameinfo = Usergameinfo::create($saveArray);
			return $this->sendResponse($usergameinfo, 'Game information saved successfully', 200);
		} 
	}
	
	public function updateWins(Request $request) {    
		$validator = Validator::make($request->all(),[ 
			'userId' => 'required',
			'gameId' => 'required',
			'gameWinFrom' => 'required'
		]);   
		if ($validator->fails()) { 
			return $this->sendError('Validation Error.', $validator->errors(), 401);
		}
		$input = $request->all(); 
		$usergameinfo = Usergameinfo::where(['gameId' => $input['gameId'], 'userId' => $input['userId']])->first();
		$saveTransaction = array();
		if($usergameinfo){
			$totalWins = $usergameinfo->totalWins;
			$updateArray['totalWins'] = $totalWins+1;
			if($input['gameWinFrom'] == 'computer'){
				$totalWinsFromComputer = $usergameinfo->totalWinsFromComputer;
				$updateArray['totalWinsFromComputer'] = $totalWinsFromComputer+1;
			}elseif($input['gameWinFrom'] == 'friend'){
				$totalWinsFromFriend = $usergameinfo->totalWinsFromFriend;
				$updateArray['totalWinsFromFriend'] = $totalWinsFromFriend+1;
			}elseif($input['gameWinFrom'] == 'indian'){
				$totalWinsFromIndian = $usergameinfo->totalWinsFromIndian;
				$updateArray['totalWinsFromIndian'] = $totalWinsFromIndian+1;
			}elseif($input['gameWinFrom'] == 'classic'){
				$totalWinsFromClassic = $usergameinfo->totalWinsFromClassic;
				$updateArray['totalWinsFromClassic'] = $totalWinsFromClassic+1;
			}else{
				$updateArray = array();
			}
			if(!empty($updateArray)){
				$usergameinfo->update($updateArray);
				return $this->sendResponse($usergameinfo, 'Total wins updated successfully.');
			}else{
				return $this->sendError('Validation Error.', ['error' => 'Not a valid game from value!'], 401);
			}
			
		}else{
			$saveArray['userId'] = $input['userId'];
			$saveArray['gameId'] = $input['gameId'];
			$saveArray['totalWins'] = 1;
			if($input['gameWinFrom'] == 'computer'){
				$saveArray['totalWinsFromComputer'] = 1;
			}elseif($input['gameWinFrom'] == 'friend'){
				$saveArray['totalWinsFromFriend'] = 1;
			}elseif($input['gameWinFrom'] == 'indian'){
				$saveArray['totalWinsFromIndian'] = 1;
			}elseif($input['gameWinFrom'] == 'classic'){
				$saveArray['totalWinsFromClassic'] = 1;
			}
			$usergameinfo = Usergameinfo::create($saveArray);
			return $this->sendResponse($usergameinfo, 'Game information saved successfully', 200);
		} 
	}
	
	public function getLeaderBoard(Request $request) {
		$validator = Validator::make($request->all(),[ 
			'userId' => 'required',
			'gameId' => 'required'
		]);   
		if ($validator->fails()) { 
			return $this->sendError('Validation Error.', $validator->errors(), 401);
		}
		$input = $request->all();
		$usergameinfo = Usergameinfo::select('users.*', 'usergameinfos.*')
                ->leftJoin('users', 'usergameinfos.userId', '=', 'users.id')
				->Where('users.id', $input['userId'])
				->Where('usergameinfos.gameId', $input['gameId'])->first();
		if(!$usergameinfo){
			return $this->sendError('Not Exist.', ['error'=>'Records not found'], 401); 
		}
		return $this->sendResponse($usergameinfo, 'Leaderboard retrieved successfully.');
	}
	public function TopWinner(Request $request) {
		
		 $validator = Validator::make($request->all(),[ 
			'userId' => 'required',
			'gameId' => 'required',
			'gameWinFrom'=>'required'
		]); 
		
		if ($validator->fails()) { 
			return $this->sendError('Validation Error.', $validator->errors(), 401);
		}
		$input = $request->all();
		
		
		
		$winfrom = $input['gameWinFrom']; 
		if($winfrom){
		switch ($winfrom) {
			case "computer":
				$usergameinfo_data = Usergameinfo::select('users.firstName', 'users.lastName', 'usergameinfos.totalWinsFromComputer as WinsFromComputer')
                ->leftJoin('users', 'usergameinfos.userId', '=', 'users.id')
				->Where('usergameinfos.gameId', $input['gameId'])->orderBy('usergameinfos.totalWinsFromComputer', 'DESC')->limit(10)->get();
				
				break;
			case "friend":
			$usergameinfo_data = Usergameinfo::select('users.firstName', 'users.lastName', 'usergameinfos.totalWinsFromFriend as WinsFromFriend')
                ->leftJoin('users', 'usergameinfos.userId', '=', 'users.id')
				->Where('usergameinfos.gameId', $input['gameId'])->orderBy('usergameinfos.totalWinsFromFriend', 'DESC')->limit(10)->get();
				break;
			case "indian":
			$usergameinfo_data = Usergameinfo::select('users.firstName', 'users.lastName', 'usergameinfos.totalWinsFromIndian as WinsFromIndian')
                ->leftJoin('users', 'usergameinfos.userId', '=', 'users.id')
				->Where('usergameinfos.gameId', $input['gameId'])->orderBy('usergameinfos.totalWinsFromIndian', 'DESC')->limit(10)->get();
				break;	
		    case "classic":
			$usergameinfo_data = Usergameinfo::select('users.firstName', 'users.lastName', 'usergameinfos.totalWinsFromClassic as WinsFromClassic')
                ->leftJoin('users', 'usergameinfos.userId', '=', 'users.id')
				->Where('usergameinfos.gameId', $input['gameId'])->orderBy('usergameinfos.totalWinsFromClassic', 'DESC')->limit(10)->get();
				
				break;
		}
		}
		return $this->sendResponse($usergameinfo_data, 'Top 10 winers List');
	}
	public function TransactionHistory(Request $request) {
		 $validator = Validator::make($request->all(),[ 
			'userId' => 'required',
			'gameId' => 'required',
			
		]); 
		
		if ($validator->fails()) { 
			return $this->sendError('Validation Error.', $validator->errors(), 401);
		}
		$input = $request->all();
		
		$transctions = Order::select('txn_amount','txn_type','created_at')->where(['user_id' => $input['userId']])->get();
		
		return $this->sendResponse($transctions, 'Transctions Details');

	} 
	public function getcoupons(Request $request) {
		$validator = Validator::make($request->all(),[ 
						'gameId' => 'required',
			
		]); 
		if ($validator->fails()) { 
			return $this->sendError('Validation Error.', $validator->errors(), 401);
		}
		$input = $request->all();
		$gameId = $input['gameId'];
		$coupons = Coupon::select('id', 'couponTitle', 'gameId', 'couponCode', 'couponValue', 'couponStartDate', 'couponEndDate', 'created_at')->where([['couponStartDate', '<=', Carbon::today()->toDateString()],['couponEndDate', '>=', Carbon::today()->toDateString()],['couponIsActive', '=', 1]])->get();
		return $this->sendResponse($coupons, 'coupons Details');

	} 
	public function availcoupon(Request $request) {
	$validator = Validator::make($request->all(),[ 
						'userId' => 'required',
						'couponCode' => 'required',
			
		]);
		if ($validator->fails()) { 
			return $this->sendError('Validation Error.', $validator->errors(), 401);
		}
		$input = $request->all();
		$userId = $input['userId'];
		$couponCode = $input['couponCode'];
	
		$coupon = Coupon::select('id', 'couponTitle', 'gameId', 'couponCode', 'couponValue', 'couponStartDate', 'couponEndDate', 'created_at')->where([['couponStartDate', '<=', Carbon::today()->toDateString()],['couponEndDate', '>=', Carbon::today()->toDateString()],['couponCode', '=', $couponCode],['couponIsActive', '=', 1]])->first();
		if(empty($coupon)){
			return $this->sendError('coupon code is not valid', 401);	
		}
	    $User_data = User::where('id', $userId)->first();
		$data = User::select('bonusMoney','availcoupon')->where('id', $userId)->first();
		$availedcoupon = $data->availcoupon;
		if($availedcoupon != null && $availedcoupon == $couponCode){
			return $this->sendError('This coupon code is already applied', 401);
		}
		$old_bonusMoney = $data->bonusMoney;
		if($User_data && $coupon){
						$update['bonusMoney'] = $old_bonusMoney+$coupon->couponValue;
				        $update['availcoupon'] = $couponCode;
			$User_data->update($update);
			return $this->sendResponse($User_data, 'coupon avail Successfully');
				} 
	}
	public function updateStatusIsonline(Request $request){
		$validator = Validator::make($request->all(),[ 
			'userId' => 'required'
		]);   
		if ($validator->fails()) { 
			return $this->sendError('Validation Error.', $validator->errors(), 401);
		}
		$input = $request->all();
		$user = User::where(['id' => $input['userId']])->first();
		
		if($user){
			$update['userIsOnline'] = 1;
			$update['updatedTime'] 	= time();
			$user->update($update);
			return $this->sendResponse($user, 'Status updated successfully.');
		}else{
			return $this->sendError('Validation Error.', ['error' => 'User does not exist!'], 401);
		}
	}
	public function updateprofile(Request $request){
		$validator = Validator::make($request->all(),[ 
			'userId' => 'required',
			'profilePic' => 'required',
			'firstName'=>'required',
			'lastName'=>'required',
			'email' => 'required|email',
			'profileBio'=>'required'
		]);
		if ($validator->fails()) { 
			return $this->sendError('Validation Error.', $validator->errors(), 401);
		}
		$input = $request->all();
		$userId = $input['userId'];
		$profilePic = $input['profilePic'];
		$firstName = $input['firstName'];
		$lastName = $input['lastName'];
		$email = $input['email'];
		$profileBio = $input['profileBio'];
		
		$User_data = User::where('id', $userId)->first();
		
		$saveImageFile = $userId.'-'.substr( md5( $userId. '-' . time() ), 0, 15) . '.jpg'; 
		$imageData = base64_decode($profilePic);
		$file =     base_path('public/images/avatars/').$saveImageFile;
		$success = file_put_contents($file, $imageData);
		if($User_data){
						$update['profilePic'] = $saveImageFile;
				        $update['firstName'] = $firstName;
						$update['lastName'] = $lastName;
						$update['email'] = $email;
						$update['profileBio'] = $profileBio;
						
			$User_data->update($update);
			return $this->sendResponse($User_data, 'Profile update successfully.');
				} 
		
	}
	public function getProfilePic(Request $request){
		$validator = Validator::make($request->all(),[ 
			'userId' => 'required',
						
		]);
		if ($validator->fails()) { 
			return $this->sendError('Validation Error.', $validator->errors(), 401);
		}
		$input = $request->all();
		$userId = $input['userId'];
		$User_data = User::select('profilePic')->where('id', $userId)->first();
		$profile_pic = base64_encode($User_data->profilePic);
		
		return $this->sendResponse($profile_pic, 'Profile pic get successfully.');
	}
	
	public function uploadProfilePic(Request $request){
		$validator = Validator::make($request->all(),[ 
			'user_id' => 'required',
			'profilePic' => 'required'
		]);
		if ($validator->fails()) { 
			return $this->sendError('Validation Error.', $validator->errors(), 401);
		}
		$input = $request->all();
		$userId = $input['user_id'];
		$profilePic = $input['profilePic'];
		$user = User::where('id', $userId)->first();
		$saveImageFile = $userId.'-'.substr( md5( $userId. '-' . time() ), 0, 15) . '.jpg'; 
		$imageData = base64_decode($profilePic);
		#$file =  base_path('public/images/avatars/').$saveImageFile;
		$file =  public_path('uploads/avatars/').$saveImageFile;
		$success = file_put_contents($file, $imageData);
		if($user){
			$update['profilePic'] = $saveImageFile;
			$user->update($update);
			return $this->sendResponse($user, 'Profile picture uploaded successfully.');
		}else{
			return $this->sendError('Invalid', 'Please provide correct details', 200);
		}
	}
}
