<?php
namespace App\Http\Controllers\Api;
use App\Http\Controllers\Api\ApiController as ApiController;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;

use App\Models\User;
use App\Models\Question;
use App\Models\Slider;
use App\Models\Language;
use App\Models\Questiontype;
use App\Models\Questionoption; 

use Illuminate\Support\Facades\Auth; 
use Validator;
use Helpers;
use DB;
use App\Coupon;
use Carbon\Carbon;
class LudoController extends ApiController {
	
	public function getQuestions(Request $request){
		$optionArray = array(
			0 => 'optionA',
			1 => 'optionB',
			2 => 'optionC',
			3 => 'optionD',
		);
		$finalQuestionArray = array();
		$questionsArray = Question::with('options')
					->orderBy('questionNumber', 'ASC')
					//->limit(1,0)
					->get();
			
		if(!empty($questionsArray)){
			foreach($questionsArray as $k => $v){
				$finalQuestionArray[$k]['questionNo'] = $v->questionNumber;
				$finalQuestionArray[$k]['question'] = $v->questionTitle;
				$finalQuestionArray[$k]['questionImg'] = "/uploads/questions/".$v->questionImage;
				$finalQuestionArray[$k]['imgCaption'] = $v->imageCaption;
				
				$questionOption = array();
				$optionAnswer = array();
				$optionCorrectAnswer = '';
				foreach($v->options as $key => $val){
					$questionOption[$optionArray[$key]] = $val->optionValue;
					$optionAnswer[] = $val->optionCorrectAnswer;
				}
				if(!empty($optionAnswer)){
					foreach($optionAnswer as $key => $vals){
						if($vals){
							$optionCorrectAnswer = $key;
						}
					}
				}
				
				$correctAnswer = isset($optionArray[$optionCorrectAnswer])?$optionArray[$optionCorrectAnswer]:'';
				
				$finalQuestionArray[$k]['options'] = $questionOption;
				$finalQuestionArray[$k]['ans'] = $correctAnswer;
			}
		}
		
		return $this->sendResponse($finalQuestionArray, 'Questions fetched successfully.');
	}
	
	public function getImages(){
		$images = Slider::all();
		$finalArray = array();
		if($images){
			foreach($images as $key => $value){
				$finalArray[] = array(
					'title' => $value->slider_title,
					'image' => "/uploads/sliders/".$value->slider_image
				);
			}
		}
		if(!empty($finalArray)){
			return $this->sendResponse($finalArray, 'Images fetched successfully.');
		}else{
			return $this->sendError('NoData', 'No records found!', 200);
		}
	}
	
	public function getRefral($referalCode = 0){
		if(is_array($referalCode)){
			$referralusers = User::select('id', 'referalCode')->whereIn('referedByCode', $referalCode)
			->orderBy('id', 'ASC')
			->limit(4,0)
			->get();
		}else{
			$referralusers = User::select('id', 'referalCode')->where('referedByCode', $referalCode)
			->orderBy('id', 'ASC')
			->limit(4,0)
			->get();
		}
		
		$userArray = $referralusers->toArray();
		return $userArray;
	}
	
	
}
