<?php

namespace App\Http\Controllers\Backend;

use App\Models\Configuration;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;

class ConfigurationController extends Controller {

    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request) {
        return view('backend.configurations.index');
    }

    /**
     * Display the specified resource by ajax request.
     *
     * @param  \App\Models\Configuration  $configuration
     * @return \Illuminate\Http\Response
     */
    public function getConfiguration(Request $request) {
        $order_by = array();
        $length = $request->length;
        $start = $request->start;
        $columnData = array(
            '#',
            'config_key',
            'config_value',
            'config_label',
            'created_at',
            'action'
        );
        $sortData = $request->order;
        $order_by[0] = $columnData[$sortData[0]['column']];
        $order_by[1] = $sortData[0]['dir'];
        $searchData = $request->searchBox;

        $totalData = Configuration::count();

        $totalFiltered = $totalData;
        $jsonArray = array(
            'draw' => $request->draw,
            'recordsTotal' => $totalData,
            'recordsFiltered' => $totalData,
            'data' => array(),
        );

        $configurationQuery = Configuration::select('id', 'config_key', 'config_value', 'config_label', 'created_at');
        if (!empty($request->searchBox)) {
            $search = $request->searchBox;
            $configurationQuery->where(function ($q) use ($search) {
                $q->Where('id', 'LIKE', "%{$search}%")
                        ->orWhere('config_key', 'LIKE', "%{$search}%")
                        ->orWhere('config_value', 'LIKE', "%{$search}%")
                        ->orWhere('config_label', 'LIKE', "%{$search}%")
                        ->orWhere('created_at', 'LIKE', "%{$search}%");
            });
        }
        $totalFiltered = $configurationQuery->count();
        $configuration = $configurationQuery->offset($start)
                ->limit($length)
                ->orderBy($order_by[0], $order_by[1])
                ->get();

        $data = array();

        if (!empty($configuration)) {
            $btn = '';
            foreach ($configuration as $key => $config) {
                $btn = '<a href="' . url("/backend/configurations/" . $config->id . "/edit") . '" data-toggle="tooltip" data-id="' . $config->id . '" title="' . __('messages.Edit') . '" data-original-title="Edit" class="edit btn btn-primary btn-sm"><i class="fa fa-edit" title="' . __('messages.Edit') . '"></i></a>';
                $btn = $btn . ' <a style="display:none;" href="javascript:void(0);" data-token="' . csrf_token() . '" class="btn btn-danger btn-sm deleteRecord" rel="' . $config->id . '" title="' . 'Delete' . '"><i class="fa fa-trash-o deleteRecord" rel="' . $config->id . '" title="' . 'Delete' . '"></i></a>';

                $nestedData['sr_no'] = $start + $key + 1;
                $nestedData['config_key'] = $config->config_key;
                $nestedData['config_value'] = $config->config_value;
                $nestedData['config_label'] = $config->config_label;
                $nestedData['created_at'] = date('j M Y h:i a', strtotime($config->created_at));
                $nestedData['action'] = $btn;
                $data[] = $nestedData;
            }
        }

        $json_data = array(
            "draw" => intval($request->input('draw')),
            "recordsTotal" => intval($totalData),
            "recordsFiltered" => intval($totalFiltered),
            "data" => $data
        );

        echo json_encode($json_data);
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create() {
        return view('backend.configurations.create');
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request) {
        $this->validate($request, [
            'config_key' => 'required|unique:configurations',
            'config_value' => 'required',
            'config_label' => 'required'
        ]);
        $posted_array['config_key'] = $request->config_key;
        $posted_array['config_value'] = $request->config_value;
        $posted_array['config_label'] = $request->config_label;

        Configuration::create($posted_array);
        //flash()->overlay(__('messages.Record created successfully.'));
        flash('Record created successfully.', 'success');
        return redirect('/backend/configurations');
    }

    /**
     * Display the specified resource.
     *
     * @param  \App\Models\Configuration  $configuration
     * @return \Illuminate\Http\Response
     */
    public function show(Configuration $configuration) {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\Models\Configuration  $configuration
     * @return \Illuminate\Http\Response
     */
    public function edit(Configuration $configuration) {
        return view('backend.configurations.edit', compact('configuration'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\Models\Configuration  $configuration
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, Configuration $configuration) {
        $this->validate($request, [
            'config_key' => [
                'required',
                //'unique:configurations'
                \Illuminate\Validation\Rule::unique('configurations')->ignore($configuration->id)
            ],
            'config_value' => 'required',
            'config_label' => 'required'
        ]);
        $posted_array['config_key'] = $request->config_key;
        $posted_array['config_value'] = $request->config_value;
        $posted_array['config_label'] = $request->config_label;

        $configuration->update($posted_array);
        //flash()->overlay('Record updated successfully.','Updated');
        flash('Record updated successfully.', 'success');
        return redirect('/backend/configurations');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Models\Configuration  $configuration
     * @return \Illuminate\Http\Response
     */
    public function destroy(Configuration $configuration) {
        $configuration->delete();
        //flash()->overlay(__('messages.Record has been deleted.'),'success');
        flash('Record has been deleted.', 'success');
        return redirect('/backend/configurations');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Models\Configuration  $configuration
     * @return \Illuminate\Http\Response
     */
    public function remove(Request $request) {
        $sID = $request->sID;
        $jsonArray = array('flag' => false);
        if (Configuration::destroy($sID)) {
            $jsonArray['flag'] = true;
        }
        echo json_encode($jsonArray);
        exit;
    }

}
