<?php

namespace App\Http\Controllers\Backend;
use App\ContactUS;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\User;
use DataTables;
use Illuminate\Support\Facades\Hash;
use App\Faq;
use Mail;
class ContactController extends Controller {

    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index() {
		 
		  $sellerTypeArray = array('' => __('messages.Please Select'), 1 => __('messages.Owner'), 2 => __('messages.Dealer'), 3 => __('messages.Admin'));
        $userStatusList = array('' => __('messages.Please Select'), 1 => __('messages.Active'), 2 => __('messages.Blocked'));
        return view('backend.contact.index', compact('sellerTypeArray', 'userStatusList'));
        
    }

    /**
     * Display the specified resource by ajax request.
     *
     * @param  \App\contactUS  $contactUS
     * @return \Illuminate\Http\Response
     */
    public function getContact(Request $request) {
		
        $order_by = array();
        $length = $request->length;
        $start = $request->start;
        $columnData = array(
            'id',
            'question',
            'answer',
			'isActive',
            'created_at',
            'action'
        );
        $sortData = $request->order;
        $order_by[0] = $columnData[$sortData[0]['column']];
        $order_by[1] = $sortData[0]['dir'];
        $searchData = $request->searchBox;

        $totalData = ContactUS::count();

        $totalFiltered = $totalData;
        $jsonArray = array(
            'draw' => $request->draw,
            'recordsTotal' => $totalData,
            'recordsFiltered' => $totalData,
            'data' => array(),
        );

        $faqQuery = ContactUS::select('id', 'name', 'email', 'message','isReplied','created_at');
        if (!empty($request->searchBox)) {
            $search = $request->searchBox;
			
            $faqQuery->where(function ($q) use ($search) {
                $q->Where('id', 'LIKE', "%{$search}%")
                        ->orWhere('name', 'LIKE', "%{$search}%")
                        ->orWhere('email', 'LIKE', "%{$search}%")
                        ->orWhere('message', 'LIKE', "%{$search}%")
						->orWhere('isReplied', 'LIKE', "%{$search}%")
						->orWhere('created_at', 'LIKE', "%{$search}%");
            });
        }
        $totalFiltered = $faqQuery->count();
        $faqs = $faqQuery->offset($start)
                ->limit($length)
                ->orderBy($order_by[0], $order_by[1])
                ->get();

        $data = array();

        if (!empty($faqs)) {
            $btn = '';
            foreach ($faqs as $key => $faq) {
                $btn = '<a href="' . url("/backend/contacts/reply/" . $faq->id ) . '" data-toggle="tooltip" data-id="' . $faq->id . '" data-original-title="Edit" class="edit btn btn-primary btn-sm" title="' . __('messages.Edit') . '">Reply</a>';
               

                $nestedData['sr_no'] = $start + $key + 1;
                $nestedData['name'] = $faq->name;
                $nestedData['email'] = $faq->email;
				$nestedData['message'] = $faq->message;
				$nestedData['isReplied'] = ($faq->isReplied == 1) ? 'Replied' : 'Not Replied';
                $nestedData['created_at'] = date('j M Y h:i a', strtotime($faq->created_at));
                $nestedData['action'] = $btn;
                $data[] = $nestedData;
            }
        }

        $json_data = array(
            "draw" => intval($request->input('draw')),
            "recordsTotal" => intval($totalData),
            "recordsFiltered" => intval($totalFiltered),
            "data" => $data
        );

        echo json_encode($json_data);
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create() {
        return view('backend.faq.create');
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request) {
        $this->validate($request, [
            'question' => 'required',
            'answer' => 'required',
            
        ]);
        $posted_array['question'] = $request->question;
        $posted_array['answer'] = $request->answer;
      

        Faq::create($posted_array);
        //flash()->overlay(__('messages.Record created successfully.'));
        flash(__('Faq created successfully.'), 'success');
        return redirect('/backend/faqs');
    }

    /**
     * Display the specified resource.
     *
     * @param  \App\Models\Page  $page
     * @return \Illuminate\Http\Response
     */
    public function show(Page $page) {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\faq  $faq
     * @return \Illuminate\Http\Response
     */
    public function edit(faq $faq) {
        return view('backend.faq.edit', compact('faq'));
    }

/**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\faq  $faq
     * @return \Illuminate\Http\Response
     */
  public function update(Request $request, Faq $faq)
    {
        $this->validate($request, [
            'question' => 'required',
            'answer' => 'required'
        ]);

        $posted_array['question'] = $request->question;
        $posted_array['answer'] = $request->answer;
        $posted_array['isActive'] = $request->isActive;
        $faq->update($posted_array);
        //flash()->overlay('Record updated successfully.','Updated');
        flash("Record updated successfully.", 'success');
        return redirect('/backend/faqs');
    }
    
   
    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Models\Page  $page
     * @return \Illuminate\Http\Response
     */
    public function destroy(Page $faq) {
        $page->delete();
        //flash()->overlay(__('messages.Record has been deleted.'),'success');
        flash(__('messages.Record has been deleted.'), 'success');
        return redirect('/backend/faqs');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Models\Makemodel  $makemodel
     * @return \Illuminate\Http\Response
     */
    public function remove(Request $request) {
        $sID = $request->sID;
        $jsonArray = array('flag' => false);
        if (Faq::destroy($sID)) {
            $jsonArray['flag'] = true;
        }
        echo json_encode($jsonArray);
        exit;
    }

		/**
     * Reply the specified user from storage.
     *
     * @param  \App\Models\Makemodel  $makemodel
     * @return \Illuminate\Http\Response
     */
    public function reply(Request $request, $id) {
       $user_id = $id;
	   $contact_data = ContactUS::where('id',$user_id)->first();
	   $user_email =  $contact_data->email;
	   $user_name = $contact_data->name;
	   return view('backend.contact.reply', compact('user_id','user_email','user_name'));
	  
    }
	public function user_reply(Request $request) {
	   $user_id = $request->contact_id;
       $user_email = $request->email;
	   $user_name = $request->contact_name;
	   $user_mail_content = $request->reply_message;
	   Mail::send('email.user_reply',
		   ['user_message' => $user_mail_content,
				'name'=>$user_name,
			]
		   , function($message)use ($request)
	   {
		   $message->from(env('ADMIN_EMAIL'),env('ADMIN_NAME'));
		   $message->to($request->email, '')->subject('Ludo and Rummy Notification!');
	   }); 
	   ContactUS::where('id',$user_id)->update(['isReplied' => '1']);
	   return redirect('/backend/contacts')->with('success','Reply Message has been sent.');
	  
    }
}
