<?php

namespace App\Http\Controllers\Backend;
use App\Models\Faq;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Models\User;
#use DataTables;
use Illuminate\Support\Facades\Hash;


class FaqController extends Controller {

    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index() {
		$sellerTypeArray = array('' => __('messages.Please Select'), 1 => __('messages.Owner'), 2 => __('messages.Dealer'), 3 => __('messages.Admin'));
        $userStatusList = array('' => __('messages.Please Select'), 1 => __('messages.Active'), 2 => __('messages.Blocked'));
        return view('backend.faq.index', compact('sellerTypeArray', 'userStatusList'));
        
    }

    /**
     * Display the specified resource by ajax request.
     *
     * @param  \App\Faq  $faq
     * @return \Illuminate\Http\Response
     */
    public function getFaq(Request $request) {
		
        $order_by = array();
        $length = $request->length;
        $start = $request->start;
        $columnData = array(
            'id',
            'question',
            'answer',
			'isActive',
            'created_at',
            'action'
        );
        $sortData = $request->order;
        $order_by[0] = $columnData[$sortData[0]['column']];
        $order_by[1] = $sortData[0]['dir'];
        $searchData = $request->searchBox;

        $totalData = Faq::count();

        $totalFiltered = $totalData;
        $jsonArray = array(
            'draw' => $request->draw,
            'recordsTotal' => $totalData,
            'recordsFiltered' => $totalData,
            'data' => array(),
        );

        $faqQuery = Faq::select('id', 'question', 'answer', 'isActive','created_at');
        if (!empty($request->searchBox)) {
            $search = $request->searchBox;
			
            $faqQuery->where(function ($q) use ($search) {
                $q->Where('id', 'LIKE', "%{$search}%")
                        ->orWhere('question', 'LIKE', "%{$search}%")
                        ->orWhere('answer', 'LIKE', "%{$search}%")
                        ->orWhere('isActive', 'LIKE', "%{$search}%")
						->orWhere('created_at', 'LIKE', "%{$search}%");
            });
        }
        $totalFiltered = $faqQuery->count();
        $faqs = $faqQuery->offset($start)
                ->limit($length)
                ->orderBy($order_by[0], $order_by[1])
                ->get();

        $data = array();

        if (!empty($faqs)) {
            $btn = '';
            foreach ($faqs as $key => $faq) {
                $btn = '<a href="' . url("/backend/faqs/" . $faq->id . "/edit") . '" data-toggle="tooltip" data-id="' . $faq->id . '" data-original-title="Edit" class="edit btn btn-primary btn-sm" title="' . __('messages.Edit') . '"><i class="fa fa-edit" title="' . __('messages.Edit') . '"></i></a>';
                $btn = $btn.' <a href="javascript:void(0);" rel="'.$faq->id.'" data-token="'.csrf_token().'" class="btn btn-danger btn-sm deleteRecord" title="' . __('messages.Delete') . '"><i class="fa fa-trash-o deleteRecord" rel="'.$faq->id.'" title="' . __('messages.Delete') . '"></i></a>';

                $nestedData['sr_no'] = $start + $key + 1;
                $nestedData['question'] = $faq->question;
                $nestedData['answer'] = $faq->answer;
				$nestedData['isActive'] = ($faq->isActive == 1) ? 'Active' : 'Inactive';
                $nestedData['created_at'] = date('j M Y h:i a', strtotime($faq->created_at));
                $nestedData['action'] = $btn;
                $data[] = $nestedData;
            }
        }

        $json_data = array(
            "draw" => intval($request->input('draw')),
            "recordsTotal" => intval($totalData),
            "recordsFiltered" => intval($totalFiltered),
            "data" => $data
        );

        echo json_encode($json_data);
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create() {
        return view('backend.faq.create');
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request) {
        $this->validate($request, [
            'question' => 'required',
            'answer' => 'required',
            
        ]);
        $posted_array['question'] = $request->question;
        $posted_array['answer'] = $request->answer;
      

        Faq::create($posted_array);
        //flash()->overlay(__('messages.Record created successfully.'));
        flash(__('Faq created successfully.'), 'success');
        return redirect('/backend/faqs');
    }

    /**
     * Display the specified resource.
     *
     * @param  \App\Models\Page  $page
     * @return \Illuminate\Http\Response
     */
    public function show(Page $page) {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\faq  $faq
     * @return \Illuminate\Http\Response
     */
    public function edit(faq $faq) {
        return view('backend.faq.edit', compact('faq'));
    }

/**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\faq  $faq
     * @return \Illuminate\Http\Response
     */
  public function update(Request $request, Faq $faq)
    {
        $this->validate($request, [
            'question' => 'required',
            'answer' => 'required'
        ]);

        $posted_array['question'] = $request->question;
        $posted_array['answer'] = $request->answer;
        $posted_array['isActive'] = $request->isActive;
        $faq->update($posted_array);
        //flash()->overlay('Record updated successfully.','Updated');
        flash("Record updated successfully.", 'success');
        return redirect('/backend/faqs');
    }
    
   
    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Models\Page  $page
     * @return \Illuminate\Http\Response
     */
    public function destroy(Page $faq) {
        $page->delete();
        //flash()->overlay(__('messages.Record has been deleted.'),'success');
        flash(__('messages.Record has been deleted.'), 'success');
        return redirect('/backend/faqs');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Models\Makemodel  $makemodel
     * @return \Illuminate\Http\Response
     */
    public function remove(Request $request) {
        $sID = $request->sID;
        $jsonArray = array('flag' => false);
        if (Faq::destroy($sID)) {
            $jsonArray['flag'] = true;
        }
        echo json_encode($jsonArray);
        exit;
    }

}
