<?php

namespace App\Http\Controllers\Backend;

use App\Models\Language;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Image;

class LanguageController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        return view('backend.languages.index');
    }
	
	/**
     * Display the specified resource by ajax request.
     *
     * @param  \App\Models\Language  $language
     * @return \Illuminate\Http\Response
     */
    public function getLanguage(Request $request) {
        $order_by = array();
        $length = $request->length;
        $start = $request->start;
        $columnData = array(
            '#',
            'id',
            'name',
            'created_at',
            'action'
        );
        $sortData = $request->order;
        $order_by[0] = $columnData[$sortData[0]['column']];
        $order_by[1] = $sortData[0]['dir'];
        $searchData = $request->searchBox;

        $totalData = Language::count();

        $totalFiltered = $totalData;
        $jsonArray = array(
            'draw' => $request->draw,
            'recordsTotal' => $totalData,
            'recordsFiltered' => $totalData,
            'data' => array(),
        );

        $languageQuery = Language::select('id', 'name', 'created_at');
        if (!empty($request->searchBox)) {
            $search = $request->searchBox;
            $languageQuery->where(function ($q) use ($search) {
                $q->Where('id', 'LIKE', "%{$search}%")
                        ->orWhere('name', 'LIKE', "%{$search}%")
                        ->orWhere('created_at', 'LIKE', "%{$search}%");
            });
        }
        $totalFiltered = $languageQuery->count();
        $language = $languageQuery->offset($start)
                ->limit($length)
                ->orderBy($order_by[0], $order_by[1])
                ->get();

        $data = array();

        if (!empty($language)) {
            $btn = '';
            foreach ($language as $key => $lang) {
                $btn = '<a href="' . url("/backend/languages/" . $lang->id . "/edit") . '" data-toggle="tooltip" data-id="' . $lang->id . '" title="Edit" data-original-title="Edit" class="edit btn btn-primary btn-sm"><i class="fa fa-edit" title="Edit"></i></a>';
                $btn = $btn . ' <a style="display:none;" href="javascript:void(0);" data-token="' . csrf_token() . '" class="btn btn-danger btn-sm deleteRecord" rel="' . $lang->id . '" title="' . 'Delete' . '"><i class="fa fa-trash-o deleteRecord" rel="' . $lang->id . '" title="' . 'Delete' . '"></i></a>';

                $nestedData['sr_no'] = $start + $key + 1;
                $nestedData['id'] = $lang->id;
                $nestedData['name'] = $lang->name;
                $nestedData['created_at'] = date('j M Y h:i a', strtotime($lang->created_at));
                $nestedData['action'] = $btn;
                $data[] = $nestedData;
            }
        }

        $json_data = array(
            "draw" => intval($request->input('draw')),
            "recordsTotal" => intval($totalData),
            "recordsFiltered" => intval($totalFiltered),
            "data" => $data
        );

        echo json_encode($json_data);
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        return view('backend.languages.create');
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $this->validate($request, [
            'name' => 'required|unique:languages'
        ]);
        $posted_array['name'] = $request->name;

        Language::create($posted_array);
        //flash()->overlay(__('messages.Record created successfully.'));
        flash('Record created successfully.', 'success');
        return redirect('/backend/languages');
    }

    /**
     * Display the specified resource.
     *
     * @param  \App\Models\Language  $language
     * @return \Illuminate\Http\Response
     */
    public function show(Language $language)
    {
        
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\Models\Language  $language
     * @return \Illuminate\Http\Response
     */
    public function edit(Language $language)
    {
        return view('backend.languages.edit', compact('language'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\Models\Language  $language
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, Language $language)
    {
        $this->validate($request, [
            'name' => [
                'required',
                //'unique:languages'
                \Illuminate\Validation\Rule::unique('languages')->ignore($language->id)
            ]
        ]);
        $posted_array['name'] = $request->name;

        $language->update($posted_array);
        //flash()->overlay('Record updated successfully.','Updated');
        flash('Record updated successfully.', 'success');
        return redirect('/backend/languages');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Models\Language  $language
     * @return \Illuminate\Http\Response
     */
    public function destroy(Language $language)
    {
        $language->delete();
        //flash()->overlay(__('messages.Record has been deleted.'),'success');
        flash('Record has been deleted.', 'success');
        return redirect('/backend/languages');
    }
	
	/**
     * Remove the specified resource from storage.
     *
     * @param  \App\Models\Language  $language
     * @return \Illuminate\Http\Response
     */
	 
    public function remove(Request $request) {
        $sID = $request->sID;
        $jsonArray = array('flag' => false);
        if (Language::destroy($sID)) {
            $jsonArray['flag'] = true;
        }
        echo json_encode($jsonArray);
        exit;
    }
}
