<?php

namespace App\Http\Controllers\Backend;

use App\Models\Page;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use \Cviebrock\EloquentSluggable\Services\SlugService;

class PageController extends Controller {

    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index() {
        return view('backend.pages.index');
    }

    /**
     * Display the specified resource by ajax request.
     *
     * @param  \App\Faq  $faq
     * @return \Illuminate\Http\Response
     */
    public function getPages(Request $request) {
        $order_by = array();
        $length = $request->length;
        $start = $request->start;
        $columnData = array(
            'id',
            'pageTitle',
            'metaTitle',
            'created_at',
            'action'
        );
        $sortData = $request->order;
        $order_by[0] = $columnData[$sortData[0]['column']];
        $order_by[1] = $sortData[0]['dir'];
        $searchData = $request->searchBox;

        $totalData = Page::count();

        $totalFiltered = $totalData;
        $jsonArray = array(
            'draw' => $request->draw,
            'recordsTotal' => $totalData,
            'recordsFiltered' => $totalData,
            'data' => array(),
        );

        $pageQuery = Page::select('id', 'pageTitle', 'metaTitle', 'created_at');
        if (!empty($request->searchBox)) {
            $search = $request->searchBox;
            $pageQuery->where(function ($q) use ($search) {
                $q->Where('id', 'LIKE', "%{$search}%")
                        ->orWhere('pageTitle', 'LIKE', "%{$search}%")
                        ->orWhere('metaTitle', 'LIKE', "%{$search}%")
                        ->orWhere('created_at', 'LIKE', "%{$search}%");
            });
        }
        $totalFiltered = $pageQuery->count();
        $pages = $pageQuery->offset($start)
                ->limit($length)
                ->orderBy($order_by[0], $order_by[1])
                ->get();

        $data = array();

        if (!empty($pages)) {
            $btn = '';
            foreach ($pages as $key => $page) {
                $btn = '<a href="' . url("/backend/pages/" . $page->id . "/edit") . '" data-toggle="tooltip" data-id="' . $page->id . '" data-original-title="Edit" class="edit btn btn-primary btn-sm" title="' . __('messages.Edit') . '"><i class="fa fa-edit" title="' . __('messages.Edit') . '"></i></a>';
                //$btn = $btn.' <a href="javascript:void(0);" rel="'.$page->id.'" data-token="'.csrf_token().'" class="btn btn-danger btn-sm deleteRecord" title="' . __('messages.Delete') . '"><i class="fa fa-trash-o deleteRecord" rel="'.$page->id.'" title="' . __('messages.Delete') . '"></i></a>';

                $nestedData['sr_no'] = $start + $key + 1;
                $nestedData['pageTitle'] = $page->pageTitle;
                $nestedData['metaTitle'] = $page->metaTitle;
                $nestedData['created_at'] = date('j M Y h:i a', strtotime($page->created_at));
                $nestedData['action'] = $btn;
                $data[] = $nestedData;
            }
        }

        $json_data = array(
            "draw" => intval($request->input('draw')),
            "recordsTotal" => intval($totalData),
            "recordsFiltered" => intval($totalFiltered),
            "data" => $data
        );

        echo json_encode($json_data);
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create() {
        return view('backend.pages.create');
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request) {
        $this->validate($request, [
            'pageTitle' => 'required',
            'pageBody' => 'required',
            'metaTitle' => 'required',
            'metaKeyword' => 'required',
            'metaDescription' => 'required'
        ]);
        $posted_array['pageTitle'] = $request->pageTitle;
        $posted_array['pageBody'] = $request->pageBody;
        $posted_array['metaTitle'] = $request->metaTitle;
        $posted_array['metaKeyword'] = $request->metaKeyword;
        $posted_array['metaDescription'] = $request->metaDescription;

        Page::create($posted_array);
        //flash()->overlay(__('messages.Record created successfully.'));
        flash(__('messages.Record created successfully.'), 'success');
        return redirect('/backend/pages');
    }

    /**
     * Display the specified resource.
     *
     * @param  \App\Models\Page  $page
     * @return \Illuminate\Http\Response
     */
    public function show(Page $page) {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\Models\Page  $page
     * @return \Illuminate\Http\Response
     */
    public function edit(Page $page) {
        return view('backend.pages.edit', compact('page'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\Models\Page  $page
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, Page $page) {
        $this->validate($request, [
            'pageTitle' => 'required',
            'pageBody' => 'required',
            'metaTitle' => 'required',
            'metaKeyword' => 'required',
            'metaDescription' => 'required'
        ]);
        $posted_array['pageTitle'] = $request->pageTitle;
        $posted_array['pageBody'] = $request->pageBody;
        $posted_array['metaTitle'] = $request->metaTitle;
        $posted_array['metaKeyword'] = $request->metaKeyword;
        $posted_array['metaDescription'] = $request->metaDescription;
        $page->update($posted_array);
        //flash()->overlay('Record updated successfully.','Updated');
        flash(__('messages.Record updated successfully.'), 'success');
        return redirect('/backend/pages');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Models\Page  $page
     * @return \Illuminate\Http\Response
     */
    public function destroy(Page $page) {
        $page->delete();
        //flash()->overlay(__('messages.Record has been deleted.'),'success');
        flash(__('messages.Record has been deleted.'), 'success');
        return redirect('/backend/pages');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Models\Makemodel  $makemodel
     * @return \Illuminate\Http\Response
     */
    public function remove(Request $request) {
        $sID = $request->sID;
        $jsonArray = array('flag' => false);
        if (Page::destroy($sID)) {
            $jsonArray['flag'] = true;
        }
        echo json_encode($jsonArray);
        exit;
    }

}
