<?php

namespace App\Http\Controllers\Backend;
use URL;
use Image;
use App\Models\Tag;
use App\Models\Post;
use App\Models\Category;
use Illuminate\Http\Request;
use App\Http\Requests\PostRequest;
use App\Http\Controllers\Controller;

class PostController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $posts = Post::with(['user', 'category', 'tags', 'comments'])->paginate(10);

        return view('backend.posts.index', compact('posts'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        $categories = Category::pluck('name', 'id')->all();
        $tags = Tag::pluck('name', 'name')->all();

        return view('backend.posts.create', compact('categories', 'tags'));
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(PostRequest $request)
    {
        $body = $request->body;
		$post_image = '';
		if($files = $request->file('post_image')){
			$name = $files->getClientOriginalName();
			$new_name =  time().$name;
			$thumsPath = public_path('uploads/post_image/thumbnail');
			$thumbImg = Image::make($files->getRealPath())->resize(980, 400);
			$thumbImg->save($thumsPath.'/'.$new_name,80);
			
			$postPath = public_path('uploads/post_image');
			$thumbImg = Image::make($files->getRealPath())->resize(1800, 600);
			$thumbImg->save($postPath.'/'.$new_name,80);
			
			$posted_array['post_image'] 	= $new_name;
		}
		$posted_array['title'] 			= $request->title;
		$posted_array['body'] 			= html_entity_decode($body);
		$posted_array['description'] 	= $request->description;
		$posted_array['category_id'] 	= $request->category_id;
		
		$post = Post::create($posted_array);

        $tagsId = collect($request->tags)->map(function($tag) {
            return Tag::firstOrCreate(['name' => $tag])->id;
        });

        $post->tags()->attach($tagsId);
        //flash()->overlay('Post created successfully.');
        flash('Post created successfully.', 'success');
        return redirect('/backend/posts');
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show(Post $post)
    {
        $post = $post->load(['user', 'category', 'tags', 'comments']);

        return view('backend.posts.show', compact('post'));
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit(Post $post)
    {
        if($post->user_id != auth()->user()->id && auth()->user()->is_admin == false) {
            //flash()->overlay("You can't edit other peoples post.");
            flash('You can\'t edit other peoples post.', 'error');
            return redirect('/backend/posts');
        }

        $categories = Category::pluck('name', 'id')->all();
        $tags = Tag::pluck('name', 'name')->all();

        return view('backend.posts.edit', compact('post', 'categories', 'tags'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(PostRequest $request, Post $post)
    {
		$body = $request->body;
		$post_image = '';
		if($files = $request->file('post_image')){
			$name = $files->getClientOriginalName();
			$new_name =  time().$name;
			
			$thumsPath = public_path('uploads/post_image/thumbnail');
			$thumbImg = Image::make($files->getRealPath())->resize(980, 400);
			$thumbImg->save($thumsPath.'/'.$new_name,80);
			
			$postPath = public_path('uploads/post_image');
			$thumbImg = Image::make($files->getRealPath())->resize(1800, 600);
			$thumbImg->save($postPath.'/'.$new_name,80);
			
			$posted_array['post_image'] 	= $new_name;
		}
		$posted_array['title'] 			= $request->title;
		$posted_array['body'] 			= html_entity_decode($body);
		$posted_array['description'] 	= $request->description;
		$posted_array['category_id'] 	= $request->category_id;
		
        $post->update($posted_array);

        $tagsId = collect($request->tags)->map(function($tag) {
            return Tag::firstOrCreate(['name' => $tag])->id;
        });

        $post->tags()->sync($tagsId);
        //flash()->overlay('Post updated successfully.');
        flash('Post updated successfully.', 'success');
        return redirect('/backend/posts');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy(Post $post)
    {
        if($post->user_id != auth()->user()->id && auth()->user()->is_admin == false) {
            //flash()->overlay("You can't delete other peoples post.");
            flash('You can\'t delete other peoples post.', 'error');
            return redirect('/backend/posts');
        }

        $post->delete();
        //flash()->overlay('Post deleted successfully.');
        flash('Post deleted successfully.', 'success');

        return redirect('/backend/posts');
    }

    public function publish(Post $post)
    {
        $post->is_published = !$post->is_published;
        $post->save();
        //flash()->overlay('Post changed successfully.');
        flash('Post changed successfully.', 'success');
        return redirect('/backend/posts');
    }
	
    public function uploadimage(Request $request){ 
        if(isset($_FILES['file'])) {
            $img = $_FILES['file'];
            $new_name =  time() . $img["name"];
            $filePath = public_path ().'/uploads/';
            $path =  $filePath.$new_name;
            if (!file_exists($filePath)) {
                mkdir($filePath, 0777, true);
            }
            move_uploaded_file($img['tmp_name'], $path);
            $imgURL = URL::to('/').'/public/uploads/'.$new_name;
            $image = '<img src="'.$imgURL.'" />';
            echo $imgURL;
            exit();
        }
    }
}
