<?php

namespace App\Http\Controllers\Backend;

use Maatwebsite\Excel\Facades\Excel;
use App\Imports\ImportQuestion;
use App\Exports\ExportQuestion;

use App\Models\Question;
use App\Models\Language;
use App\Models\Questiontype;
use App\Models\Questionoption;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Image;

class QuestionController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        return view('backend.questions.index');
    }
	
	/**
     * Display the specified resource by ajax request.
     *
     * @param  \App\Models\Slider  $slider
     * @return \Illuminate\Http\Response
     */
    public function getQuestion(Request $request) {
        $order_by = array();
        $length = $request->length;
        $start = $request->start;
        $columnData = array(
            '#',
            'questionNumber',
            'questionTitle',
            'imageCaption',
            #'wrongAnswerSpecification',
            'created_at',
            'action'
        );
        $sortData = $request->order;
        $order_by[0] = $columnData[$sortData[0]['column']];
        $order_by[1] = $sortData[0]['dir'];
        $searchData = $request->searchBox;

        $totalData = Question::count();

        $totalFiltered = $totalData;
        $jsonArray = array(
            'draw' => $request->draw,
            'recordsTotal' => $totalData,
            'recordsFiltered' => $totalData,
            'data' => array(),
        );

        if (empty($searchData)) {
            $questions = Question::offset($start)
                    ->limit($length)
                    ->orderBy($order_by[0], $order_by[1])
                    ->get();
        } else {
            $search = $request->searchBox;
            $questions = Question::where('id', 'LIKE', "%{$search}%")
                    ->orWhere('questionTitle', 'LIKE', "%{$search}%")
                    ->orWhere('imageCaption', 'LIKE',"%{$search}%")
                    ->orWhere('questionNumber', 'LIKE',"%{$search}%")
                    ->orWhere('created_at', 'LIKE', "%{$search}%")
                    ->offset($start)
                    ->limit($length)
                    ->orderBy($order_by[0], $order_by[1])
                    ->get();

            $totalFiltered = Question::where('id', 'LIKE', "%{$search}%")
                    ->orWhere('questionTitle', 'LIKE', "%{$search}%")
                    ->orWhere('imageCaption', 'LIKE',"%{$search}%")
                    ->orWhere('questionNumber', 'LIKE',"%{$search}%")
                    ->orWhere('created_at', 'LIKE', "%{$search}%")
                    ->count();
        }
        $data = array();

        if (!empty($questions)) {
            $btn = '';
            foreach ($questions as $key => $question) {
                $btn = '<a href="' . url("/backend/questions/" . $question->id . "/edit") . '" data-toggle="tooltip" data-id="' . $question->id . '" data-original-title="Edit" title="Edit" class="edit btn btn-primary btn-sm"><i class="fa fa-edit" title="Edit"></i></a>';
                $btn = $btn . ' <a href="javascript:void(0);" rel="' . $question->id . '" data-token="' . csrf_token() . '" class="btn btn-danger btn-sm deleteRecord" title="Delete"><i class="fa fa-trash-o deleteRecord" rel="' . $question->id . '" title="Delete"></i></a>';

                $nestedData['sr_no'] = $start + $key + 1;
                $nestedData['questionTitle'] = $question->questionTitle;
                $nestedData['imageCaption'] = $question->imageCaption;
                $nestedData['questionNumber'] = $question->questionNumber;
                $nestedData['created_at'] = date('j M Y h:i a', strtotime($question->created_at));
                $nestedData['action'] = $btn;
                $data[] = $nestedData;
            }
        }

        $json_data = array(
            "draw" => intval($request->input('draw')),
            "recordsTotal" => intval($totalData),
            "recordsFiltered" => intval($totalFiltered),
            "data" => $data
        );

        echo json_encode($json_data);
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
		$option_array = array();
		$languages = Language::pluck('name', 'id')->all();
		$language_array[0] = 'Please Select';
        if (!empty($languages)) {
            foreach ($languages as $key => $value) {
                $language_array[$key] = $value;
            }
        }
		
		$questiontypes = Questiontype::pluck('typeTitle', 'id')->all();
		$questiontype_array[0] = 'Please Select';
        if (!empty($questiontypes)) {
            foreach ($questiontypes as $key => $value) {
                $questiontype_array[$key] = $value;
            }
        }
		$option_array = array(
			'optionOne' => 'Option A',
			'optionTwo' => 'Option B',
			'optionThree' => 'Option C',
			'optionFour' => 'Option D',
		);
        return view('backend.questions.create', compact('language_array', 'questiontype_array', 'option_array'));
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $this->validate($request, [
            #'languageId' => 'required',
            'questionTitle' => 'required',
            'questionImage' => 'required|mimes:jpeg,png,jpg,gif,svg|max:2048',
			'optionOne' => 'required',
			'optionTwo' => 'required',
			'optionThree' => 'required',
			'optionFour' => 'required',
			'optionCorrectAnswer' => 'required',
			'imageCaption' => 'required',
			'questionNumber' => 'required|unique:questions',
			#'wrongAnswerSpecification' => 'required',
        ]);
        if ($files = $request->file('questionImage')) {
			/*
            $name = $files->getClientOriginalName();
            #$ext = $files->getClientOriginalExtension();
            $new_name = time() . $name;

            $thumsPath = public_path('uploads/questions/thumbnail');
            $thumbImg = Image::make($files->getRealPath())->resize(120, 50);
            $thumbImg->save($thumsPath . '/' . $new_name, 80);

            $questionPath = public_path('uploads/questions');
            #$thumbImg = Image::make($files->getRealPath())->resize(1347, 465);
            $files->save($questionPath . '/' . $new_name, 100);
			*/
			
			$name = $files->getClientOriginalName();
            $new_name = time() . $name;

            $sliderPath = public_path('uploads/questions');
            $imgFile = Image::make($files->getRealPath());
			$imgFile->save($sliderPath . '/' . $new_name, 100);
            $posted_array['questionImage'] = $new_name;
        }
        $posted_array['languageId'] = 1;
        $posted_array['typeId'] = '0';
        $posted_array['questionTitle'] = $request->questionTitle;
        $posted_array['imageCaption'] = $request->imageCaption;
        $posted_array['questionNumber'] = $request->questionNumber;
        #$posted_array['rightAnswerSpecification'] = $request->rightAnswerSpecification;
        #$posted_array['wrongAnswerSpecification'] = $request->wrongAnswerSpecification;
		
		$question_id = Question::create($posted_array)->id;
		
        $option_array['optionOne'] = $request->optionOne;
        $option_array['optionTwo'] = $request->optionTwo;
        $option_array['optionThree'] = $request->optionThree;
        $option_array['optionFour'] = $request->optionFour;
        $answer_option = $request->optionCorrectAnswer;
		foreach($option_array as $key => $value){
			$saveOption = array();
			$optionCorrectAnswer = 0;
			if($key == $answer_option){
				$optionCorrectAnswer = 1;
			}
			$saveOption = array(
				'questionId' => $question_id,
				'optionValue' => $value,
				'optionCorrectAnswer' => $optionCorrectAnswer
			);
			Questionoption::create($saveOption);
		}
        
        flash('Record created successfully.', 'success');
        return redirect('/backend/questions');
    }

    /**
     * Display the specified resource.
     *
     * @param  \App\Models\Question  $question
     * @return \Illuminate\Http\Response
     */
    public function show(Question $question)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\Models\Question  $question
     * @return \Illuminate\Http\Response
     */
    public function edit(Question $question)
    {
		$option_array = array();
		$languages = Language::pluck('name', 'id')->all();
		$language_array[0] = 'Please Select';
        if (!empty($languages)) {
            foreach ($languages as $key => $value) {
                $language_array[$key] = $value;
            }
        }
		
		$questiontypes = Questiontype::pluck('typeTitle', 'id')->all();
		$questiontype_array[0] = 'Please Select';
        if (!empty($questiontypes)) {
            foreach ($questiontypes as $key => $value) {
                $questiontype_array[$key] = $value;
            }
        }
		$option_array = array(
			'optionOne' => 'Option A',
			'optionTwo' => 'Option B',
			'optionThree' => 'Option C',
			'optionFour' => 'Option D',
		);
		
		$optionsss_array = array(
			0 => 'optionOne',
			1 => 'optionTwo',
			2 => 'optionThree',
			3 => 'optionFour' ,
		);
		
		$questionsArray = Question::with('options')->where('id', $question->id)->first();
        
		$questionOption = array();
		$optionAnswer = array();
		$optionCorrectAnswer = '';
		foreach($questionsArray->options as $key => $val){
			$questionOption[] = $val->optionValue;
			$optionAnswer[$optionsss_array[$key]] = $val->optionCorrectAnswer;
		}
		if(!empty($optionAnswer)){
			foreach($optionAnswer as $key => $vals){
				if($vals){
					$optionCorrectAnswer = $key;
				}
			}
		}
		return view('backend.questions.edit', compact('question', 'language_array', 'questiontype_array', 'option_array', 'optionCorrectAnswer', 'questionOption'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\Models\Question  $question
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, Question $question)
    {
        $this->validate($request, [
            #'languageId' => 'required',
            'questionTitle' => 'required',
            'questionImage' => 'mimes:jpeg,png,jpg,gif,svg|max:2048',
			'optionOne' => 'required',
			'optionTwo' => 'required',
			'optionThree' => 'required',
			'optionFour' => 'required',
			'optionCorrectAnswer' => 'required',
			'imageCaption' => 'required',
			'questionNumber' => [
                'required',
                \Illuminate\Validation\Rule::unique('questions')->ignore($question->id)
            ],
			#'rightAnswerSpecification' => 'required',
			#'wrongAnswerSpecification' => 'required',
        ]);
        if ($files = $request->file('questionImage')) {
            $name = $files->getClientOriginalName();
            $new_name = time() . $name;

            $sliderPath = public_path('uploads/questions');
            $imgFile = Image::make($files->getRealPath());
			$imgFile->save($sliderPath . '/' . $new_name, 100);
            $posted_array['questionImage'] = $new_name;
        }
        $posted_array['languageId'] = 1;#$request->languageId;
        $posted_array['typeId'] = '0';
        $posted_array['questionTitle'] = $request->questionTitle;
        $posted_array['questionNumber'] = $request->questionNumber;
        $posted_array['imageCaption'] = $request->imageCaption;
        #$posted_array['rightAnswerSpecification'] = $request->rightAnswerSpecification;
        #$posted_array['wrongAnswerSpecification'] = $request->wrongAnswerSpecification;
		
        $question->update($posted_array);
		$qID = $request->qId;
		if(Questionoption::where('questionId', $qID)->delete()){
			$option_array['optionOne'] = $request->optionOne;
			$option_array['optionTwo'] = $request->optionTwo;
			$option_array['optionThree'] = $request->optionThree;
			$option_array['optionFour'] = $request->optionFour;
			$answer_option = $request->optionCorrectAnswer;
			foreach($option_array as $key => $value){
				$saveOption = array();
				$optionCorrectAnswer = 0;
				if($key == $answer_option){
					$optionCorrectAnswer = 1;
				}
				$saveOption = array(
					'questionId' => $qID,
					'optionValue' => $value,
					'optionCorrectAnswer' => $optionCorrectAnswer
				);
				Questionoption::create($saveOption);
			}
		}
		
        flash('Record updated successfully.', 'success');
        return redirect('/backend/questions');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Models\Question  $question
     * @return \Illuminate\Http\Response
     */
    public function destroy(Question $question)
    {
        $question->delete();
        flash('Record has been deleted.', 'success');
        return redirect('/backend/questions');
    }
	
	/**
     * Remove the specified resource from storage.
     *
     * @param  \App\Models\Question  $question
     * @return \Illuminate\Http\Response
     */
    public function remove(Request $request) {
        $sID = $request->sID;
        $jsonArray = array('flag' => false);
        if (Question::destroy($sID)) {
			Questionoption::where('questionId', $sID)->delete();
            $jsonArray['flag'] = true;
        }
        echo json_encode($jsonArray);
        exit;
    }
	
	public function importView(Request $request){
        return view('backend.questions.import');
    }

    public function import(Request $request){
        Excel::import(new ImportQuestion, $request->file('file')->store('files'));
        #return redirect()->back();
    }

    public function exportQuestions(Request $request){
        return Excel::download(new ExportQuestion, 'questions.xlsx');
    }
}
