<?php

namespace App\Http\Controllers\Backend;

use App\Models\Slider;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Image;
use DataTables;

class SliderController extends Controller {

    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request) {
        return view('backend.sliders.index');
    }

    /**
     * Display the specified resource by ajax request.
     *
     * @param  \App\Models\Slider  $slider
     * @return \Illuminate\Http\Response
     */
    public function getSliders(Request $request) {
        $order_by = array();
        $length = $request->length;
        $start = $request->start;
        $columnData = array(
            '#',
            'slider_title',
            'slider_image',
            'created_at',
            'action'
        );
        $sortData = $request->order;
        $order_by[0] = $columnData[$sortData[0]['column']];
        $order_by[1] = $sortData[0]['dir'];
        $searchData = $request->searchBox;

        $totalData = Slider::count();

        $totalFiltered = $totalData;
        $jsonArray = array(
            'draw' => $request->draw,
            'recordsTotal' => $totalData,
            'recordsFiltered' => $totalData,
            'data' => array(),
        );

        if (empty($searchData)) {
            $sliders = Slider::offset($start)
                    ->limit($length)
                    ->orderBy($order_by[0], $order_by[1])
                    ->get();
        } else {
            $search = $request->searchBox;
            $sliders = Slider::where('id', 'LIKE', "%{$search}%")
                    ->orWhere('slider_title', 'LIKE', "%{$search}%")
                    //->orWhere('slider_image', 'LIKE',"%{$search}%")
                    ->orWhere('created_at', 'LIKE', "%{$search}%")
                    ->offset($start)
                    ->limit($length)
                    ->orderBy($order_by[0], $order_by[1])
                    ->get();

            $totalFiltered = Slider::where('id', 'LIKE', "%{$search}%")
                    ->orWhere('slider_title', 'LIKE', "%{$search}%")
                    //->orWhere('slider_image', 'LIKE',"%{$search}%")
                    ->orWhere('created_at', 'LIKE', "%{$search}%")
                    ->count();
        }
        $data = array();

        if (!empty($sliders)) {
            $btn = '';
            foreach ($sliders as $key => $slider) {
                $btn = '<a href="' . url("/backend/sliders/" . $slider->id . "/edit") . '" data-toggle="tooltip" data-id="' . $slider->id . '" data-original-title="Edit" title="' . __('messages.Edit') . '" class="edit btn btn-primary btn-sm"><i class="fa fa-edit" title="' . __('messages.Edit') . '"></i></a>';
                $btn = $btn . ' <a href="javascript:void(0);" rel="' . $slider->id . '" data-token="' . csrf_token() . '" class="btn btn-danger btn-sm deleteRecord" title="' . __('messages.Delete') . '"><i class="fa fa-trash-o deleteRecord" rel="' . $slider->id . '" title="' . __('messages.Delete') . '"></i></a>';

                $nestedData['sr_no'] = $start + $key + 1;
                $nestedData['slider_title'] = $slider->slider_title;
                $nestedData['slider_image'] = (!empty($slider->slider_image)) ? '<img height="50px" width="75px" src="' . url('/uploads/sliders') . '/' . $slider->slider_image . '" alt="' . $slider->slider_title . '" />' : '';
                $nestedData['created_at'] = date('j M Y h:i a', strtotime($slider->created_at));
                $nestedData['action'] = $btn;
                $data[] = $nestedData;
            }
        }

        $json_data = array(
            "draw" => intval($request->input('draw')),
            "recordsTotal" => intval($totalData),
            "recordsFiltered" => intval($totalFiltered),
            "data" => $data
        );

        echo json_encode($json_data);
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create() {
        return view('backend.sliders.create');
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request) {
        $this->validate($request, [
            'slider_title' => 'required',
            'slider_image' => 'required|mimes:jpeg,png,jpg,gif,svg|max:2048',
                //'slider_image.*' => 'mimes:jpeg,png,jpg,gif,svg|max:2048'
        ]);
        if ($files = $request->file('slider_image')) {
            $name = $files->getClientOriginalName();
            #$ext = $files->getClientOriginalExtension();
            $new_name = time() . $name;

            $sliderPath = public_path('uploads/sliders');
            #$thumbImg = Image::make($files->getRealPath())->resize(1850, 985);
            #$thumbImg = Image::make($files->getRealPath())->resize(1347, 465);
            $imgFile = Image::make($files->getRealPath());
			$imgFile->save($sliderPath . '/' . $new_name, 100);
			#$imgFile->save($sliderPath, 100);

            $posted_array['slider_image'] = $new_name;
        }
        $posted_array['slider_title'] = $request->slider_title;
        $posted_array['slider_url'] = $request->slider_url;

        Slider::create($posted_array);
        //flash()->overlay(__('messages.Record created successfully.'));
        flash('Record created successfully.', 'success');
        return redirect('/backend/sliders');
    }

    /**
     * Display the specified resource.
     *
     * @param  \App\Models\Slider  $slider
     * @return \Illuminate\Http\Response
     */
    public function show(Slider $slider) {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\Models\Slider  $slider
     * @return \Illuminate\Http\Response
     */
    public function edit(Slider $slider) {
        return view('backend.sliders.edit', compact('slider'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\Models\Slider  $slider
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, Slider $slider) {
        $this->validate($request, [
            'slider_title' => 'required',
            'slider_image' => 'mimes:jpeg,png,jpg,gif,svg|max:2048',
                //'slider_image' => 'mimes:jpeg,png,jpg,gif,svg'
        ]);
        if ($files = $request->file('slider_image')) {
            $name = $files->getClientOriginalName();
            #$ext = $files->getClientOriginalExtension();
            $new_name = time() . $name;
			
            $sliderPath = public_path('uploads/sliders');
            #$thumbImg = Image::make($files->getRealPath())->resize(1850, 985);
            #$thumbImg = Image::make($files->getRealPath())->resize(1347, 465);
            $imgFile = Image::make($files->getRealPath());
			$imgFile->save($sliderPath . '/' . $new_name, 100);
			#$imgFile->save($sliderPath, $files);

            $posted_array['slider_image'] = $new_name;
        }
        $posted_array['slider_title'] = $request->slider_title;
        $posted_array['slider_url'] = $request->slider_url;

        $slider->update($posted_array);
        //flash()->overlay('Record updated successfully.','Updated');
        flash('Record updated successfully.', 'success');
        return redirect('/backend/sliders');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Models\Slider  $slider
     * @return \Illuminate\Http\Response
     */
    public function destroy(Slider $slider) {
        $slider->delete();
        //flash()->overlay(__('messages.Record has been deleted.'),'success');
        flash('Record has been deleted.', 'success');
        return redirect('/backend/sliders');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Models\Makemodel  $makemodel
     * @return \Illuminate\Http\Response
     */
    public function remove(Request $request) {
        $sID = $request->sID;
        $jsonArray = array('flag' => false);
        if (Slider::destroy($sID)) {
            $jsonArray['flag'] = true;
        }
        echo json_encode($jsonArray);
        exit;
    }

}
