<?php

namespace App\Models;
use App\Models\Questionoption;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Question extends Model
{
    use HasFactory;
	protected $fillable = [
		'languageId',
		'typeId',
		'questionNumber',
		'questionTitle',
		'questionImage',
		'imageCaption',
		'rightAnswerSpecification',
		'wrongAnswerSpecification',
		'created_at'
	];
	
	public function options(){
		return $this->hasMany(Questionoption::class, 'questionId','id');
	}
}
