<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateQuestionsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('questions', function (Blueprint $table) {
            $table->id();
			$table->unsignedInteger('languageId');
			$table->unsignedInteger('typeId');
			$table->longText('questionTitle')->nullable();
			$table->longText('questionDesc')->nullable();
			$table->string('questionImage')->nullable();
			$table->string('imageCaption')->nullable();
			$table->string('rightAnswerSpecification')->nullable();
			$table->string('wrongAnswerSpecification')->nullable();
			$table->tinyInteger('questionIsActive')->default(1);
			$table->tinyInteger('questionIsDeleted')->default(0);
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('questions');
    }
}
