@extends('layouts.backend.master')
@section('content')
<div class="content-wrapper">
    <section class="content-header">
        <h1><i class="fa fa-cogs"></i> {{ 'Edit' }} {{ 'Configuration' }} <small>{{ 'Control' }} {{ 'Panel' }} {{ 'Manage' }} {{ 'Configurations' }}</small></h1>
        <ol class="breadcrumb">
            <li><a href="{{ url('backend/configurations') }}"><i class="fa fa-dashboard"></i>{{ 'Go Back' }}</a></li>
            <li class="active">{{ 'Edit' }} {{ 'Configuration' }}</li>
        </ol>
    </section>
    <section class="content container-fluid">
        <div class="row">
            <div class="col-md-12">
                <div class="box">
                    <div class="box-header">
                        <h3 class="box-title">{{ 'Edit' }} {{ 'Configuration' }}</h3>
                    </div>
                    <!-- /.box-header -->
                    <div class="box-body">
                        {!! Form::model($configuration, ['method' => 'PUT', 'url' => "/backend/configurations/{$configuration->id}", 'class' => '', 'role' => 'form']) !!}

                        @include('backend.configurations._form')

                        <div class="box-footer">
                            <button color="primary" type="submit" class="btn btn-info pull-left">{{ 'Save' }}</button>
                            <a href="{{ url('backend/configurations') }}" class="btn btn-default pull-right">{{ 'Cancel' }}</a>
                        </div>
                        {!! Form::close() !!}
                    </div>
                </div>
            </div>
        </div>
    </section>
</div>

@endsection