@extends('layouts.backend.master')
@section('content')	
<div class="content-wrapper">
    <section class="content-header">
        <h1><i class="fa fa-money"></i> Contact Data </h1>
        <ol class="breadcrumb">
            <!--li><a href="{{ url('/backend/users/create') }}"><i class="fa fa-plus"></i> Add User </a></li-->
            <li class="active">View</li>
        </ol>
    </section>


    <section class="content container-fluid">
        <div class="row">
            @include('flash::message')
					   @if(Session::has('success'))
					<div class="alert alert-success">
					{{ Session::get('success') }}
					</div>
			@endif
        </div>
        <div class="row">
            <div class="col-md-12">
                <div class="box">
                    <div class="box-header">
                        <h3 class="box-title">Contact Data</h3>
                    </div>
                    <!-- /.box-header -->
                    <div class="box-body">
                        <div class="row">
                            <div class="col-md-3">
                              
                            </div>
                            <div class="col-md-3">
                                
                            </div>
                            <div class="col-md-3">
                                <div class="form-group">
                                    {!! Form::label('searchBox', 'Search Keyword', ['class' => 'control-label']) !!}
                                    {!! Form::text('searchBox', null, ['class' => 'form-control', 'id' => 'searchBox', 'placeHolder'=> 'Enter Keyword']) !!}
                                </div>
                            </div>
                            <div class="col-md-3">
                                <div class="form-group">
                                    {!! Form::label('searchBox', '&nbsp;', ['class' => 'control-label']) !!}
                                    <br />
                                    <button color="primary" type="button" value="Search" id="searchButton" class="btn btn-info pull-left">Search</button>
                                    <button type="button" value="Reset" id="resetButton" onclick="location.href ='{{'/backend/faqs'}}'" class="btn btn-default pull-left" style="margin-left: 10px;">Reset</button>
                                </div>
                            </div>
                        </div>
                        <hr />
                        <table id="userList" class="table table-bordered table-hover">
                            <thead>
                                <tr>
                                    <th>#</th>
                                    <th>name</th>
									<th>email</th>
                                    <th>Message</th>
									<th>isReplied</th>
                                    <th>Created At</th>
                                    <th>Action</th>
                                </tr>
                            </thead>
                            <tbody>	

                            </tbody>

                            <tfoot>
                                <tr>
                                    <th>#</th>
                                    <th>name</th>
									<th>email</th>
                                    <th>Message</th>
									<th>isReplied</th>
                                    <th>Created At</th>
                                    <th>Action</th>
                                    
                                </tr>
                            </tfoot>
                        </table>
                    </div>
                    <!-- /.box-body -->

                </div>
            </div>
        </div>
    </section>
</div>

<script type="text/javascript">
    var oTable;
    var token = $('meta[name="csrf-token"]').attr('content');
    $(document).ready(function () {
        oTable = $('#userList').dataTable({
            "processing": true,
            "serverSide": true,
            "responsive": true,
            "fnDrawCallback": function (oSettings) {
                $('#userList').tooltip();
            },
            "ajax": {
                "url": SITEURL + "/backend/contacts/getContact",
                "type": "POST",
                "dataType": "json",
                "data": function (d) {
                    d.myKey = "myValue";
					d.searchBox = $('#searchBox').val();
                    d._token = token;
                }
            },
            "bFilter": false,
            "aoColumnDefs": [{"bSortable": false, "aTargets": [0, 5]}],
            "order": [[4, "desc"]],
            "aoColumns": [
                {"data": "sr_no", "sClass": "text-center"},
                {"data": "name"},
				{"data": "email"},
				{"data": "message"},
                {"data": "isReplied"},
                {"data": "created_at"},
				{"data": "action"},
                
            ]
        });

        $('#searchButton').click(function () {
            oTable.fnDraw();
        });

        $('#searchBox').keydown(function (e) {
            if (e.keyCode == 13) {
                oTable.fnDraw();
            }
        });
		
		 jQuery("#userList").on("click", ".deleteRecord", function () {
            var sID = jQuery(this).attr('rel');
            //alert(sID);
            swal({
                title: "Are you sure?",
                text: "You will not be able to recover this record in future!",
                type: "warning",
                showCancelButton: true,
                confirmButtonColor: "#DD6B55",
                confirmButtonText: "Yes, delete it!",
                cancelButtonText: "No, cancel plz!",
                closeOnConfirm: false,
                closeOnCancel: false
            },
            function (isConfirm) {
                if (isConfirm) {
                    $.ajax({
                        url: SITEURL + "/backend/faqs/remove",
                        type: 'POST',
                        dataType: 'json',
                        data: {sID: sID},
                        success: function (data) {
                            swal({title: "Deleted", text: "Record has been deleted.", type: "success", confirmButtonText: "Ok"});
                            bResetDisplay = false;
                            /* override default behaviour */
                            oTable.fnDraw();
                            bResetDisplay = true;
                            /*restore default behaviour */
                        },
                        error: function () {
                            swal({title: "Warning", text: "Do not have permission to delete the record.", type: "error", confirmButtonText: "{{ __('messages.Ok')}}"});
                        }
                    });
                } else {
                    swal({title: "Cancelled", text: "Record is safe now.", type: "error", confirmButtonText: "Ok"});
                }
            });
        });
    });
</script>

@endsection
