@extends('layouts.backend.master')
@section('content')
<div class="content-wrapper">
    <section class="content-header">
        <h1><i class="fa fa-cogs"></i> {{ 'Edit' }} {{ 'Language' }} <small>{{ 'Control' }} {{ 'Panel' }} {{ 'Manage' }} {{ 'Languages' }}</small></h1>
        <ol class="breadcrumb">
            <li><a href="{{ url('backend/languages') }}"><i class="fa fa-dashboard"></i>{{ 'Go Back' }}</a></li>
            <li class="active">{{ 'Edit' }} {{ 'Language' }}</li>
        </ol>
    </section>
    <section class="content container-fluid">
        <div class="row">
            <div class="col-md-12">
                <div class="box">
                    <div class="box-header">
                        <h3 class="box-title">{{ 'Edit' }} {{ 'Language' }}</h3>
                    </div>
                    <!-- /.box-header -->
                    <div class="box-body">
                        {!! Form::model($language, ['method' => 'PUT', 'url' => "/backend/languages/{$language->id}", 'class' => '', 'role' => 'form']) !!}

                        @include('backend.languages._form')

                        <div class="box-footer">
                            <button color="primary" type="submit" class="btn btn-info pull-left">{{ 'Save' }}</button>
                            <a href="{{ url('backend/languages') }}" class="btn btn-default pull-right">{{ 'Cancel' }}</a>
                        </div>
                        {!! Form::close() !!}
                    </div>
                </div>
            </div>
        </div>
    </section>
</div>

@endsection