<div class="form-group{{ $errors->has('title') ? ' has-error' : '' }}">
    {!! Form::label('title', 'Title', ['class' => 'control-label']) !!}
	{!! Form::text('title', null, ['class' => 'form-control', 'required', 'autofocus']) !!}
	<span class="help-block">
		<strong>{{ $errors->first('title') }}</strong>
	</span>
</div>

<div class="form-group{{ $errors->has('description') ? ' has-error' : '' }}">
    {!! Form::label('description', 'Small description', ['class' => 'control-label']) !!}
	{!! Form::textarea('description', null, ['class' => 'form-control', 'required', 'autofocus']) !!}
	<span class="help-block">
		<strong>{{ $errors->first('description') }}</strong>
	</span>
</div>

<div class="form-group{{ $errors->has('body') ? ' has-error' : '' }}">
    {!! Form::label('body', 'Body', ['class' => 'control-label']) !!}
	{!! Form::textarea('body', null, ['class' => 'form-control summernote', 'required']) !!}
	<span class="help-block">
		<strong>{{ $errors->first('body') }}</strong>
	</span>
</div>

<div class="form-group{{ $errors->has('category_id') ? ' has-error' : '' }}">
    {!! Form::label('category_id', 'Category', ['class' => 'control-label']) !!}
	{!! Form::select('category_id', $categories, null, ['class' => 'form-control', 'required']) !!}
	<span class="help-block">
		<strong>{{ $errors->first('category_id') }}</strong>
	</span>
</div>
@php
    if(isset($post)) {
        $tag = $post->tags->pluck('name')->all();
    } else {
        $tag = null;
    }
@endphp

<div class="form-group{{ $errors->has('tags') ? ' has-error' : '' }}">
    {!! Form::label('tags', 'Tag', ['class' => 'control-label']) !!}
	{!! Form::select('tags[]', $tags, $tag, ['class' => 'form-control select2-tags', 'required', 'multiple']) !!}

	<span class="help-block">
		<strong>{{ $errors->first('tags') }}</strong>
	</span>
</div>

<div class="form-group{{ $errors->has('post_image') ? ' has-error' : '' }}">
    {!! Form::label('post_image', 'Post Image', ['class' => 'control-label']) !!}
	{!! Form::file('post_image', null, ['class' => 'form-control', 'required', 'autofocus']) !!}
	<span class="help-block">
		<strong>{{ $errors->first('post_image') }}</strong>
	</span>
</div>

<input type="hidden" id="uploadUrl" url="{{url('backend/posts/uploadimage')}}" />
