@extends('layouts.backend.master')
@section('content')	
<div class="content-wrapper">
  	<section class="content-header">
    	<h1> Posts <small>Control Panel Manage Posts</small></h1>
		<ol class="breadcrumb">
			<li><a href="{{ url('backend/posts/create') }}"><i class="fa fa-plus"></i> Add Post</a></li>
			<li class="active">View</li>
		</ol>
  	</section>
	<section class="content container-fluid">
		<div class="row">
			@include('flash::message')
		</div>
		<div class="row">
			<div class="col-md-12">
				<div class="box">
					<div class="box-header">
						<h3 class="box-title">Posts List</h3>
					</div>
					<!-- /.box-header -->
					<div class="box-body">
						<table class="table">
                            <thead>
                                <tr>
                                    <th>Title</th>
                                    <th>Desc</th>
                                    <th>Author</th>
                                    <th>Category</th>
                                    <th>Tags</th>
                                    <th>Published</th>
                                    <th>Action</th>
                                </tr>
                            </thead>
                            <tbody>
                                @forelse ($posts as $post)
                                    <tr>
                                        <td>{{ $post->title }}</td>
                                        <td>{{ str_limit($post->description, 60) }}</td>
                                        <td>{{ $post->user->name }}</td>
                                        <td>{{ $post->category->name }}</td>
                                        <td>{{ $post->tags->implode('name', ', ') }}</td>
                                        <td>{{ $post->published }}</td>
                                        <td>
                                            @if (Auth::user()->is_admin)
                                                @php
                                                    if($post->published == 'Yes') {
                                                        $label = 'Draft';
                                                    } else {
                                                        $label = 'Publish';
                                                    }
                                                @endphp
                                                <a href="{{ url("/backend/posts/{$post->slug}/publish") }}" data-method="PUT" data-token="{{ csrf_token() }}" data-confirm="Are you sure?" class="btn btn-xs btn-warning">{{ $label }}</a>
                                            @endif
                                            <a href="{{ url("/backend/posts/{$post->slug}") }}" class="btn btn-xs btn-success">Show</a>
                                            <a href="{{ url("/backend/posts/{$post->slug}/edit") }}" class="btn btn-xs btn-info">Edit</a>
                                            <a href="{{ url("/backend/posts/{$post->slug}") }}" data-method="DELETE" data-token="{{ csrf_token() }}" data-confirm="Are you sure?" class="btn btn-xs btn-danger">Delete</a>
                                        </td>
                                    </tr>
                                @empty
                                    <tr>
                                        <td colspan="5">No post available.</td>
                                    </tr>
                                @endforelse
                            </tbody>
                        </table>

                        {!! $posts->links() !!}
					</div>
						<!-- /.box-body -->
				</div>
			</div>
		  </div>
	</section>
</div>

@endsection
