@extends('layouts.backend.master')
@section('content')	
<div class="content-wrapper">
    <section class="content-header">
        <h1><i class="fa fa-users"></i> Users <small>Control Panel Manage Users</small></h1>
        <ol class="breadcrumb">
            <!--li><a href="{{ url('/backend/users/create') }}"><i class="fa fa-plus"></i> Add User </a></li-->
            <li class="active">View</li>
        </ol>
    </section>


    <section class="content container-fluid">
        <div class="row">
            @include('flash::message')
        </div>
        <div class="row">
            <div class="col-md-12">
                <div class="box">
                    <div class="box-header">
                        <h3 class="box-title">Online Users</h3>
                    </div>
                    <!-- /.box-header -->
                    <div class="box-body">
                        <div class="row">
                            <div class="col-md-3">
                                <!--div class="form-group">
                                    {!! Form::label('userIsOnline', 'User Status', ['class' => 'control-label']) !!}
                                    {!! Form::select('userIsOnline', $user_status_array, null, ['class' => 'form-control', 'id' => 'user_status']) !!}
                                </div-->
                            </div>
                            <div class="col-md-3">
                                <!--div class="form-group">
                                    {!! Form::label('isProfileUpdated', __('messages.User Status'), ['class' => 'control-label']) !!}
                                    {!! Form::select('isProfileUpdated', $userStatusList, null, ['class' => 'form-control', 'id' => 'isProfileUpdated']) !!}
                                </div-->
                            </div>
                            <div class="col-md-3">
                                <div class="form-group">
                                    {!! Form::label('searchBox', 'Search Keyword', ['class' => 'control-label']) !!}
                                    {!! Form::text('searchBox', null, ['class' => 'form-control', 'id' => 'searchBox', 'placeHolder'=> 'Enter Keyword']) !!}
                                </div>
                            </div>
                            <div class="col-md-3">
                                <div class="form-group">
                                    {!! Form::label('searchBox', '&nbsp;', ['class' => 'control-label']) !!}
                                    <br />
                                    <button color="primary" type="button" value="Search" id="searchButton" class="btn btn-info pull-left">Search</button>
                                    <button type="button" value="Reset" id="resetButton" onclick="location.href ='{{'/backend/users'}}'" class="btn btn-default pull-left" style="margin-left: 10px;">Reset</button>
                                </div>
                            </div>
                        </div>
                        <hr />
                        <table id="userList" class="table table-bordered table-hover">
                            <thead>
                                <tr>
                                    <th>#</th>
                                    <th>First Name</th>
                                    <th>Last Name</th>
                                    <th>Email</th>
                                    <th>Mobile Number</th>
                                    <th>Profile Status</th>
                                    <th>Created At</th>
                                    <th>Action</th>
                                </tr>
                            </thead>
                            <tbody>	

                            </tbody>

                            <tfoot>
                                <tr>
                                    <th>#</th>
                                    <th>First Name</th>
                                    <th>Last Name</th>
                                    <th>Email</th>
                                    <th>Mobile Number</th>
                                    <th>Profile Status</th>
                                    <th>Created At</th>
                                    <th>Action</th>
                                </tr>
                            </tfoot>
                        </table>
                    </div>
                    <!-- /.box-body -->

                </div>
            </div>
        </div>
    </section>
</div>

<script type="text/javascript">
    var oTable;
    var token = $('meta[name="csrf-token"]').attr('content');
    $(document).ready(function () {
        oTable = $('#userList').dataTable({
            "processing": true,
            "serverSide": true,
            "responsive": true,
            "fnDrawCallback": function (oSettings) {
                $('#userList').tooltip();
            },
            "ajax": {
                "url": SITEURL + "/backend/users/getUser",
                "type": "POST",
                "dataType": "json",
                "data": function (d) {
                    d.myKey = "myValue";
					d.searchBox = $('#searchBox').val();
                    d.isProfileUpdated = $('#isProfileUpdated').val();
                    d.userIsOnline = 1;
                    d._token = token;
                }
            },
            "bFilter": false,
            "aoColumnDefs": [{"bSortable": false, "aTargets": [0, 7]}],
            "order": [[6, "desc"]],
            "aoColumns": [
                {"data": "sr_no", "sClass": "text-center"},
                {"data": "firstName"},
                {"data": "lastName"},
                {"data": "email"},
                {"data": "mobileNo"},
                {"data": "isProfileUpdated"},
                {"data": "created_at"},
                {"data": "action"}
            ]
        });

        $('#isProfileUpdated').change(function () {
            oTable.fnDraw();
        });
		
		$('#user_status').change(function () {
            oTable.fnDraw();
        });

        $('#searchButton').click(function () {
            oTable.fnDraw();
        });

        $('#searchBox').keydown(function (e) {
            if (e.keyCode == 13) {
                oTable.fnDraw();
            }
        });

        jQuery("#userList").on("click", ".deleteRecord", function () {
            var sID = jQuery(this).attr('rel');
            //alert(sID);
            swal({
                title: "Are you sure?",
                text: "You will not be able to recover this record in future!",
                type: "warning",
                showCancelButton: true,
                confirmButtonColor: "#DD6B55",
                confirmButtonText: "Yes, delete it!",
                cancelButtonText: "No, cancel plz!",
                closeOnConfirm: false,
                closeOnCancel: false
            },
            function (isConfirm) {
                if (isConfirm) {
                    $.ajax({
                        url: SITEURL + "/backend/users/remove",
                        type: 'POST',
                        dataType: 'json',
                        data: {sID: sID},
                        success: function (data) {
                            swal({title: "Deleted", text: "Record has been deleted.", type: "success", confirmButtonText: "Ok"});
                            bResetDisplay = false;
                            /* override default behaviour */
                            oTable.fnDraw();
                            bResetDisplay = true;
                            /*restore default behaviour */
                        },
                        error: function () {
                            swal({title: "Warning", text: "Do not have permission to delete the record.", type: "error", confirmButtonText: "{{ __('messages.Ok')}}"});
                        }
                    });
                } else {
                    swal({title: "Cancelled", text: "Record is safe now.", type: "error", confirmButtonText: "Ok"});
                }
            });
        });
    });
</script>


<!--script type="text/javascript">
    var oTable;
    $(document).ready(function() {
        oTable= $('#usersListtable').dataTable({
             "processing": true,
             "serverSide": true,
             "responsive": true,
             "fnDrawCallback" : function(oSettings){$('#usersListtable').tooltip();},
             "ajax": {
                 "url": "<?php #echo base_url('backend/website_config/get_website_config');    ?>",
                 "type": "POST",
                 "data": function ( d ){
                    d.myKey = "myValue";
                    d.searchBox = $('#searchBox').val();
                 }
             },
             "bFilter": false,
             "aoColumnDefs": [{ "bSortable": false, "aTargets": [ 0,3 ] }],
             "order": [[ 1, "desc" ]],
             "aoColumns": [
                    { "data": "sr_no", "sClass": "text-center"},
                    { "data": "config_key" },
                    { "data": "config_label" },
                    { "data": "action" }
             ]
        });

        $('#searchButton').click( function(){
            oTable.fnDraw();
        });

        $('#searchBox').keydown(function (e){
            if(e.keyCode == 13){
                oTable.fnDraw();
            }
        });

        $('#reSet').click( function(){
            $('#company_id').val($('#company_id option[selected]').val());
            $('#facility_id').empty();
            $('#facility_id').append('<option value="0" selected="selected">-Select-</option>');
            $('#pStatus').val($('#pStatus option[selected]').val());
            $('#searchBox').val('');
            oTable.fnDraw();
        });
    });



    jQuery("#usersListtable" ).on("click", ".activeRecord", function(){
        var sID= jQuery(this).attr('rel');
        var button=jQuery(this);
        $.ajax({
            url: '<?php #echo site_url('backend/website_config/status');    ?>',
            type: 'post',
            dataType: 'json',
            data: {sID:sID, sStatus:0},
            success: function(data){
                button.removeClass('activeRecord').addClass('deactiveRecord');
                button.removeClass('fa fa-check-square').addClass('fa fa-ban');
                button.attr('title','active');
                $('#usersListtable').tooltip();
                swal("", "website-config has deactivated successfully!", "success");
                oTable.fnDraw();
            },
            error: function(){
                swal("warning", "dont have permision to dactivate website-config", "error");
            }
        });
    });


    jQuery("#usersListtable" ).on("click", ".deactiveRecord", function(){
        var sID= jQuery(this).attr('rel');
        var button=jQuery(this);
        $.ajax({
            url: '<?php #echo site_url('backend/website_config/status');    ?>',
            type: 'post',
            dataType: 'json',
            data: {sID:sID, sStatus:1},
            success: function(data){
                button.addClass('activeRecord').removeClass('deactiveRecord');
                button.removeClass('fa fa-ban').addClass('fa fa-check-square');
                button.attr('title','inactive');
                $('#usersListtable').tooltip();
                swal("", "website-config has activated successfully!", "success");
                oTable.fnDraw();
            },
            error: function(){
                swal("warning", "dont have permision to actived website-config.", "error");
            }
        });
    });

    jQuery("#usersListtable" ).on("click", ".deleteRecord", function(){
        var sID= jQuery(this).attr('rel');
        //alert(sID);
        swal({
          title: "Are you sure?",
          text: "You will not be able to recover this user in future!",
          type: "warning",
          showCancelButton: true,
          confirmButtonColor: "#DD6B55",
          confirmButtonText: "Yes, delete it!",
          cancelButtonText: "No, cancel plz!",
          closeOnConfirm: false,
          closeOnCancel: false
        },
        function(isConfirm){
          if (isConfirm) {
                $.ajax({
                    url: '<?php #echo site_url('backend/website_config/delete');    ?>',
                    type: 'post',
                    dataType: 'json',
                    data: {sID:sID},
                    success: function(data){
                        swal("Deleted", "website-config has been deleted.", "success");
                        bResetDisplay = false;
                        /* override default behaviour */
                        oTable.fnDraw();
                        bResetDisplay = true;
                         /*restore default behaviour */
                    },
                    error: function(){
                        swal("warning", "dont have permision to deleted website-config.", "error");
                    }
                });
          } else {
                swal("Cancelled", "You are safe now.", "error");
          }
        });
    });
    $('#searchBox').keydown(function (e){
        if(e.keyCode == 13){
            oTable.fnDraw();
        }
    });
</script-->

@endsection
