<?php

use Illuminate\Support\Facades\Route;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|

*/

Route::get('/', function () {
    return redirect('/login');
});


Auth::routes();

Route::get('/home', [App\Http\Controllers\HomeController::class, 'index'])->name('home');


Route::group(['prefix' => 'backend', 'as' => 'backend.', 'namespace' => 'Backend', 'middleware' => ['admin']], function () {
	
	Route::get('/dashboard', 'DashboardController@index')->name('dashboard');
	Route::post('/uploadEditorImage', 'DashboardController@uploadEditorImage');
    Route::get('/setLanguage/{locale}', 'DashboardController@setLanguage');
    Route::match(['get', 'post'], '/control-panel-change-password', 'DashboardController@changePassword')->middleware('admin');
        
	Route::resource('/users', 'UsersController');
	Route::delete('users/destroy', 'UsersController@massDestroy')->name('users.massDestroy');
	Route::post('/users/getUser', 'UsersController@getUser')->middleware('admin');
	Route::post('/users/remove', 'UsersController@remove')->middleware('admin');
    Route::get('/leaderboard', 'UsersController@userLeaderBoard')->middleware('admin');
	Route::get('/offlineusers', 'UsersController@offlineUsers')->middleware('admin');
	Route::get('/onlineusers', 'UsersController@onlineUsers')->middleware('admin');
	Route::post('/users/getLeaderBoard', 'UsersController@getLeaderBoard')->middleware('admin');
	Route::get('/users/referal/{id}', 'UsersController@referal')->middleware('admin');
	Route::get('/users/edit/{id}', 'UsersController@edit')->middleware('admin');
	Route::put('/users/update/{id}', 'UsersController@update')->middleware('admin');
    Route::get('/update-password','UsersController@showChanegePasswordGet')->middleware('admin');
    Route::post('/change-password-post','UsersController@changePasswordPost')->middleware('admin');

	Route::resource('/languages', 'LanguageController', ['except' => ['show']]);
	Route::post('/languages/getLanguage', 'LanguageController@getLanguage')->middleware('admin');
	Route::post('/languages/remove', 'LanguageController@remove')->middleware('admin');
	
	Route::resource('/questions', 'QuestionController', ['except' => ['show']]);
	Route::post('/questions/getQuestion', 'QuestionController@getQuestion')->middleware('admin');
	Route::post('/questions/remove', 'QuestionController@remove')->middleware('admin');
	
	Route::get('/questions/file-import','QuestionController@importView')->name('import-view');
	Route::post('/questions/import','QuestionController@import')->name('import');
	Route::get('/questions/export-questions','QuestionController@exportQuestions')->name('export-users');
	
	Route::resource('/configurations', 'ConfigurationController', ['except' => ['show']]);
	Route::post('/configurations/getConfiguration', 'ConfigurationController@getConfiguration')->middleware('admin');
	Route::post('/configurations/remove', 'ConfigurationController@remove')->middleware('admin');
	
	   
	Route::resource('/sliders', 'SliderController', ['except' => ['show']]);
	Route::post('/sliders/getSliders', 'SliderController@getSliders')->middleware('admin');
	Route::post('/sliders/remove', 'SliderController@remove')->middleware('admin');
	
	
	Route::resource('/pages', 'PageController', ['except' => ['show']]);
	Route::post('/pages/getPages', 'PageController@getPages')->middleware('admin');
	Route::post('/pages/remove', 'PageController@remove')->middleware('admin');
	
});
