<div class="form-group<?php echo e($errors->has('config_key') ? ' has-error' : ''); ?>">
    <?php echo Form::label('config_key', 'Config Key', ['class' => 'control-label']); ?>

    <?php if(\Route::getCurrentRoute()->getActionMethod() == 'edit'): ?>
        <?php echo Form::text('config_key', null, ['class' => 'form-control', 'autofocus', 'disabled']); ?>

        <?php echo e(Form::hidden('config_key')); ?>

    <?php else: ?>
        <?php echo Form::text('config_key', null, ['class' => 'form-control', 'autofocus']); ?>

    <?php endif; ?>
    <span class="help-block">
        <strong><?php echo e($errors->first('config_key')); ?></strong>
    </span>
</div>

<div class="form-group<?php echo e($errors->has('config_value') ? ' has-error' : ''); ?>">
    <?php echo Form::label('config_value', 'Config Value', ['class' => 'control-label']); ?>

    <?php if(\Route::getCurrentRoute()->getActionMethod() == 'edit' && $configuration->config_key == "admin_email"): ?>
        <?php echo Form::email('config_value', null, ['class' => 'form-control', 'autofocus', 'oninvalid' => "this.setCustomValidity('".'Please enter the valid email'."')", 'oninput' => "setCustomValidity('')"]); ?>

        <p><?php echo e('Note: Admin email address used to get the all email notifications generated by the system.'); ?></p>
    <?php else: ?>
        <?php echo Form::text('config_value', null, ['class' => 'form-control', 'autofocus']); ?>

    <?php endif; ?>
    <span class="help-block">
        <strong><?php echo e($errors->first('config_value')); ?></strong>
    </span>
</div>

<div class="form-group<?php echo e($errors->has('config_label') ? ' has-error' : ''); ?>">
    <?php echo Form::label('config_label', 'Config Label', ['class' => 'control-label']); ?>

    <?php echo Form::text('config_label', null, ['class' => 'form-control', 'autofocus']); ?>

    <span class="help-block">
        <strong><?php echo e($errors->first('config_label')); ?></strong>
    </span>
</div>
<?php /**PATH /home/kwizzers/kwizzers/resources/views/backend/configurations/_form.blade.php ENDPATH**/ ?>