
<?php $__env->startSection('content'); ?>	
<div class="content-wrapper">
    <section class="content-header">
        <h1><i class="fa fa-cogs"></i> <?php echo e('Language'); ?> <small><?php echo e('Control'); ?> <?php echo e('Panel'); ?> <?php echo e('Manage'); ?> <?php echo e('Languages'); ?></small></h1>
        <ol class="breadcrumb">
            <li><a href="<?php echo e(url('backend/languages/create')); ?>"><i class="fa fa-plus"></i> <?php echo e('Create'); ?> <?php echo e('Language'); ?></a></li>
            <li class="active"><?php echo e('View'); ?></li>
        </ol>
    </section>
    <section class="content container-fluid">
        <div class="row">
            <?php echo $__env->make('flash::message', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
        </div>
        <div class="row">
            <div class="col-md-12">
                <div class="box">
                    <div class="box-header">
                        <h3 class="box-title"><?php echo e('Languages'); ?></h3>
                    </div>
                    <!-- /.box-header -->
                    <div class="box-body">
                        <div class="row">
                            <div class="col-md-4">
                                <div class="form-group">
                                    <?php echo Form::label('searchBox', 'Search Keyword', ['class' => 'control-label']); ?>

                                    <?php echo Form::text('searchBox', null, ['class' => 'form-control', 'id' => 'searchBox', 'placeHolder' => 'Enter Keyword' ]); ?>

                                </div>
                            </div>
                            <div class="col-md-4">
                                <div class="form-group">
                                    <?php echo Form::label('searchBox', '&nbsp;', ['class' => 'control-label']); ?>

                                    <br />
                                    <button color="primary" type="button" value="Search" id="searchButton" class="btn btn-info pull-left"><?php echo e('Search'); ?></button>
                                    <button type="button" value="Reset" id="resetButton" onclick="location.href ='<?php echo e('/backend/configurations'); ?>'" class="btn btn-default pull-left" style="margin-left: 10px;"><?php echo e('Reset'); ?></button>
                                </div>
                            </div>
                        </div>
                        <hr />
                        <table class="table table-striped table-bordered table-hover jambo_table" id="configuration" >
                            <thead>
                                <tr class="headings">
                                    <th>#</th>
                                    <th>ID</th>
                                    <th>Name</th>
                                    <th>Created At</th>
                                    <th>Action</th>
                                </tr>
                            </thead>
                            <tbody>
                            </tbody>
                            <tfoot>
                                <tr class="headings">
                                    <th>#</th>
                                    <th>ID</th>
                                    <th>Name</th>
                                    <th>Created At</th>
                                    <th>Action</th>
                                </tr>
                            </tfoot>
                        </table>
                    </div>
                    <!-- /.box-body -->
                </div>
            </div>
        </div>
    </section>
</div>


<script type="text/javascript">
    var oTable;
    var token = $('meta[name="csrf-token"]').attr('content');
    $(document).ready(function () {
        oTable = $('#configuration').dataTable({
            "processing": true,
            "serverSide": true,
            "responsive": true,
            "fnDrawCallback": function (oSettings) {
                $('#configuration').tooltip();
            },
            "ajax": {
                "url": SITEURL + "/backend/languages/getLanguage",
                "type": "POST",
                "dataType": "json",
                "data": function (d) {
                    d.myKey = "myValue";
                    d.searchBox = $('#searchBox').val();
                    d._token = token;
                }
            },
            "bFilter": false,
            "aoColumnDefs": [{"bSortable": false, "aTargets": [0, 4]}],
            "order": [[3, "desc"]],
            "aoColumns": [
                {"data": "sr_no", "sClass": "text-center"},
                {"data": "id"},
                {"data": "name"},
                {"data": "created_at"},
                {"data": "action"}
            ]
        });

        $('#searchButton').click(function () {
            oTable.fnDraw();
        });

        $('#searchBox').keydown(function (e) {
            if (e.keyCode == 13) {
                oTable.fnDraw();
            }
        });

        jQuery("#configuration").on("click", ".deleteRecord", function () {
            var sID = jQuery(this).attr('rel');
            swal({
                title: "<?php echo e('Are you sure?'); ?>",
                text: "<?php echo e('You will not be able to recover this record in future!'); ?>",
                type: "warning",
                showCancelButton: true,
                confirmButtonColor: "#DD6B55",
                confirmButtonText: "<?php echo e('Yes, delete it!'); ?>",
                cancelButtonText: "<?php echo e('No, cancel plz!'); ?>",
                closeOnConfirm: false,
                closeOnCancel: false
            },
            function (isConfirm) {
                if (isConfirm) {
                    $.ajax({
                        url: SITEURL + "/backend/languages/remove",
                        type: 'POST',
                        dataType: 'json',
                        data: {sID: sID},
                        success: function (data) {
                            swal({title: "<?php echo e('Deleted'); ?>", text: "<?php echo e('Record has been deleted.'); ?>", type: "success", confirmButtonText: "<?php echo e('Ok'); ?>"});
                            bResetDisplay = false;
                            /* override default behaviour */
                            oTable.fnDraw();
                            bResetDisplay = true;
                            /*restore default behaviour */
                        },
                        error: function () {
                            swal({title: "<?php echo e('Warning'); ?>", text: "<?php echo e('Do not have permission to delete the record.'); ?>", type: "error", confirmButtonText: "<?php echo e('Ok'); ?>"});
                        }
                    });
                } else {
                    swal({title: "<?php echo e('Cancelled'); ?>", text: "<?php echo e('Record is safe now.'); ?>", type: "error", confirmButtonText: "<?php echo e('Ok'); ?>"});
                }
            });
        });
    });
</script>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.backend.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH E:\wamp\www\kwizzers\resources\views/backend/languages/index.blade.php ENDPATH**/ ?>