
<?php $__env->startSection('content'); ?>	
<div class="content-wrapper">
    <section class="content-header">
        <h1><i class="fa fa-picture-o"></i> Images <small>Control Panel Manage Images</small></h1>
        <ol class="breadcrumb">
            <li><a href="<?php echo e(url('backend/sliders/create')); ?>"><i class="fa fa-plus"></i> Create Image</a></li>
            <li class="active">View</li>
        </ol>
    </section>
    <section class="content container-fluid">
        <div class="row">
            <?php echo $__env->make('flash::message', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
        </div>
        <div class="row">
            <div class="col-md-12">
                <div class="box">
                    <div class="box-header">
                        <h3 class="box-title">Images</h3>
                    </div>
                    <!-- /.box-header -->
                    <div class="box-body">
                        <div class="row border-primary">
                            <div class="col-md-4">
                                <div class="form-group">
                                    <?php echo Form::label('searchBox', 'Search Keyword', ['class' => 'control-label']); ?>

                                    <?php echo Form::text('searchBox', null, ['class' => 'form-control', 'id' => 'searchBox', 'placeHolder'=> 'Enter Keyword']); ?>

                                </div>
                            </div>
                            <div class="col-md-4">
                                <div class="form-group">
                                    <?php echo Form::label('searchBox', '&nbsp;', ['class' => 'control-label']); ?>

                                    <br />
                                    <button color="primary" type="button" value="Search" id="searchButton" class="btn btn-info pull-left">Search</button>
                                    <button type="button" value="Reset" id="resetButton" onclick="location.href ='<?php echo e('/backend/sliders'); ?>'" class="btn btn-default pull-left" style="margin-left: 10px;">Reset</button>
                                </div>
                            </div>
                        </div>
                        <hr />
                        <table id="sliderList" class="table table-bordered table-hover">
                            <thead>
                                <tr>
                                    <th>#</th>
                                    <th>Title</th>
                                    <th>Image</th>
                                    <th>Created At</th>
                                    <th>Action</th>
                                </tr>
                            </thead>
                            <tbody>	

                            </tbody>

                            <tfoot>
                                <tr>
                                    <th>#</th>
                                    <th>Title</th>
                                    <th>Image</th>
                                    <th>Created At</th>
                                    <th>Action</th>
                                </tr>
                            </tfoot>
                        </table>

                    </div>
                    <!-- /.box-body -->
                </div>
            </div>
        </div>
    </section>
</div>

<script type="text/javascript">
    var SITEURL = '<?php echo e(URL::to('')); ?>';
    $(function () {
        $.ajaxSetup({
        headers: {
                'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
            }
        });
    });
    var oTable;
    var token = $('meta[name="csrf-token"]').attr('content');
    $(document).ready(function () {
        oTable = $('#sliderList').dataTable({
        "processing": true,
                "serverSide": true,
                "responsive": true,
                "fnDrawCallback": function (oSettings) {
                $('#sliderList').tooltip();
                },
                "ajax": {
                    "url": SITEURL + "/backend/sliders/getSliders",
                            "type": "POST",
                            "dataType": "json",
                            "data": function (d) {
                            d.myKey = "myValue";
                                    d.searchBox = $('#searchBox').val();
                                    d._token = token;
                            }
                },
                "bFilter": false,
                "aoColumnDefs": [{"bSortable": false, "aTargets": [0, 2, 4]}],
                "order": [[3, "desc"]],
                "aoColumns": [
                {"data": "sr_no", "sClass": "text-center"},
                {"data": "slider_title"},
                {"data": "slider_image"},
                {"data": "created_at"},
                {"data": "action"}
                ]
        });
    $('#searchButton').click(function () {
        oTable.fnDraw();
    });
    $('#searchBox').keydown(function (e) {
        if (e.keyCode == 13) {
            oTable.fnDraw();
        }
    });
    jQuery("#sliderList").on("click", ".deleteRecord", function () {
        var sID = jQuery(this).attr('rel');
            //alert(sID);
            swal({
                title: "Are you sure?",
                text: "You will not be able to recover this record in future!",
                type: "warning",
                showCancelButton: true,
                confirmButtonColor: "#DD6B55",
                confirmButtonText: "Yes, delete it!",
                cancelButtonText: "No, cancel plz!",
                closeOnConfirm: false,
                closeOnCancel: false
            },
            function (isConfirm) {
                if (isConfirm) {
                    $.ajax({
                        url: SITEURL + "/backend/sliders/remove",
                        type: 'POST',
                        dataType: 'json',
                        data: {sID: sID},
                        success: function (data) {
                            swal({title: "Deleted", text: "Record has been deleted.", type: "success", confirmButtonText: "Ok"});
                            bResetDisplay = false;
                            /* override default behaviour */
                            oTable.fnDraw();
                            bResetDisplay = true;
                            /*restore default behaviour */
                        },
                        error: function () {
                            swal({title: "<?php echo e('Warning'); ?>", text: "Do not have permission to delete the record.", type: "error", confirmButtonText: "Ok"});
                        }
                    });
                } else {
                    swal({title: "Cancelled')}}", text: "Record is safe now.", type: "error", confirmButtonText: "Ok"});
                }
            });
        });
    });
</script>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.backend.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH E:\wamp\www\kwizzers\resources\views/backend/sliders/index.blade.php ENDPATH**/ ?>